rule win_pickpocket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pickpocket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pickpocket"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 740f b990cc0000 e8???????? }
            // n = 4, score = 400
            //   85c0                 | push                esi
            //   740f                 | mov                 eax, dword ptr [eax + 4]
            //   b990cc0000           | imul                edx, ecx, 0x30
            //   e8????????           |                     

        $sequence_1 = { e8???????? 85c0 750f b962890100 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | mov                 edx, dword ptr [esp + 0x1c]
            //   750f                 | mov                 ecx, esi
            //   b962890100           | push                ebx

        $sequence_2 = { e8???????? 85c0 740f b990cc0000 e8???????? }
            // n = 5, score = 400
            //   e8????????           |                     
            //   85c0                 | pop                 esi
            //   740f                 | mov                 dword ptr [esi + 0x50], eax
            //   b990cc0000           | mov                 dword ptr [esi + 0x54], eax
            //   e8????????           |                     

        $sequence_3 = { eb05 b960cb0000 e8???????? eb02 33c0 }
            // n = 5, score = 400
            //   eb05                 | mov                 ecx, dword ptr [eax + 0x40]
            //   b960cb0000           | movzx               eax, byte ptr [eax + 0x25]
            //   e8????????           |                     
            //   eb02                 | mov                 dword ptr [ebp - 0x98], ecx
            //   33c0                 | mov                 dword ptr [ebp - 0xbc], ecx

        $sequence_4 = { 790e b91dca0000 e8???????? 8907 }
            // n = 4, score = 400
            //   790e                 | dec                 eax
            //   b91dca0000           | add                 esi, 0x20
            //   e8????????           |                     
            //   8907                 | dec                 eax

        $sequence_5 = { 7504 33c0 eb0a b9e8d70000 }
            // n = 4, score = 400
            //   7504                 | inc                 ebp
            //   33c0                 | xor                 ecx, ecx
            //   eb0a                 | dec                 esp
            //   b9e8d70000           | mov                 dword ptr [esp + 0x28], ecx

        $sequence_6 = { 8a4201 84c0 7823 83e17f 0fb6c0 c1e107 03c8 }
            // n = 7, score = 400
            //   8a4201               | and                 dword ptr [esp + 0x20], 0
            //   84c0                 | dec                 esp
            //   7823                 | lea                 eax, [esp + 0x20]
            //   83e17f               | inc                 ecx
            //   0fb6c0               | mov                 ebx, ecx
            //   c1e107               | movups              xmm0, xmmword ptr [eax]
            //   03c8                 | dec                 eax

        $sequence_7 = { 7404 8b01 eb03 83c8ff 83f804 }
            // n = 5, score = 400
            //   7404                 | dec                 eax
            //   8b01                 | mov                 ecx, esi
            //   eb03                 | dec                 eax
            //   83c8ff               | or                  edi, eax
            //   83f804               | dec                 eax

        $sequence_8 = { a846 750f b99be00100 e8???????? e9???????? }
            // n = 5, score = 400
            //   a846                 | test                eax, eax
            //   750f                 | je                  0x16cb
            //   b99be00100           | push                dword ptr [ebp - 0x38]
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_9 = { b9dccc0000 e9???????? b9cecc0000 e9???????? b9c7cc0000 e9???????? }
            // n = 6, score = 400
            //   b9dccc0000           | dec                 ecx
            //   e9????????           |                     
            //   b9cecc0000           | mov                 ecx, edi
            //   e9????????           |                     
            //   b9c7cc0000           | dec                 esp
            //   e9????????           |                     

    condition:
        7 of them and filesize < 1458176
}