rule win_pillowmint_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pillowmint."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pillowmint"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48c7442460feffffff 48895808 48897018 48897820 488b05???????? 4833c4 488985d0000000 }
            // n = 7, score = 100
            //   48c7442460feffffff     | mov    edi, 2
            //   48895808             | lea                 ebx, [edi + 2]
            //   48897018             | inc                 ecx
            //   48897820             | mov                 edx, 0xffff
            //   488b05????????       |                     
            //   4833c4               | dec                 eax
            //   488985d0000000       | mov                 ebp, dword ptr [esp + 0x38]

        $sequence_1 = { 488b8c24a0000000 e8???????? 48c78424b80000000f000000 4889bc24b0000000 c68424a000000000 4883bc24d800000010 720d }
            // n = 7, score = 100
            //   488b8c24a0000000     | mov                 dword ptr [esp + 0x38], esi
            //   e8????????           |                     
            //   48c78424b80000000f000000     | inc    ebp
            //   4889bc24b0000000     | lea                 eax, [esi - 0xb]
            //   c68424a000000000     | dec                 eax
            //   4883bc24d800000010     | lea    edx, [0x28e2f]
            //   720d                 | dec                 eax

        $sequence_2 = { 7534 8b461c 0fb713 498d0c01 4181f8b80a4c53 7509 448b3491 }
            // n = 7, score = 100
            //   7534                 | lea                 edx, [edi + 1]
            //   8b461c               | dec                 ebp
            //   0fb713               | sub                 esi, esp
            //   498d0c01             | dec                 ecx
            //   4181f8b80a4c53       | sar                 esi, 2
            //   7509                 | dec                 ecx
            //   448b3491             | mov                 ecx, esi

        $sequence_3 = { e8???????? 488b4608 488d3d68fb2200 488b80f8000000 488bdf bd10000000 c605????????00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b4608             | mov                 eax, 0x99999999
            //   488d3d68fb2200       | inc                 ecx
            //   488b80f8000000       | imul                edi
            //   488bdf               | sar                 edx, 2
            //   bd10000000           | jns                 0x9bb
            //   c605????????00       |                     

        $sequence_4 = { 488d4c2468 e8???????? 90 4c8d05360f0300 488bd0 488d8c24c0000000 e8???????? }
            // n = 7, score = 100
            //   488d4c2468           | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [ebp - 0x40], ecx
            //   4c8d05360f0300       | dec                 eax
            //   488bd0               | test                ecx, ecx
            //   488d8c24c0000000     | je                  0x88b
            //   e8????????           |                     

        $sequence_5 = { 498bc5 482bc1 483bc2 7305 488bd7 eb03 4803d1 }
            // n = 7, score = 100
            //   498bc5               | mov                 esi, dword ptr [ebp - 9]
            //   482bc1               | dec                 eax
            //   483bc2               | mov                 edi, dword ptr [ebp - 0x11]
            //   7305                 | dec                 esp
            //   488bd7               | mov                 ebp, dword ptr [ebp - 0x19]
            //   eb03                 | dec                 eax
            //   4803d1               | mov                 dword ptr [ebp - 0x69], edi

        $sequence_6 = { 0fbe00 8d0480 8d80effeffff 8d0442 83f81e 0f8730010000 }
            // n = 6, score = 100
            //   0fbe00               | int3                
            //   8d0480               | dec                 esp
            //   8d80effeffff         | lea                 eax, [0x36705]
            //   8d0442               | dec                 eax
            //   83f81e               | lea                 eax, [0x2f329]
            //   0f8730010000         | dec                 eax

        $sequence_7 = { e8???????? 8985c0000000 488d95c0000000 e8???????? 4885c0 0f853e040000 488b05???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8985c0000000         | dec                 eax
            //   488d95c0000000       | lea                 ecx, [0x2da6c]
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   0f853e040000         | mov                 eax, ecx
            //   488b05????????       |                     

        $sequence_8 = { 90 4c8d051c170300 488bd0 488d4dd8 e8???????? 90 4983c9ff }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   4c8d051c170300       | lea                 ecx, [ebp + 0x178]
            //   488bd0               | je                  0xe9
            //   488d4dd8             | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 edx, [ebp + 0x50]
            //   4983c9ff             | dec                 eax

        $sequence_9 = { 4883c708 48833b00 75a9 418b4620 4983c614 85c0 0f8579ffffff }
            // n = 7, score = 100
            //   4883c708             | mov                 eax, 5
            //   48833b00             | dec                 eax
            //   75a9                 | lea                 edx, [0x361b7]
            //   418b4620             | jmp                 0x16d2
            //   4983c614             | dec                 eax
            //   85c0                 | lea                 edx, [0x361ba]
            //   0f8579ffffff         | inc                 ecx

    condition:
        7 of them and filesize < 4667392
}