rule win_pipemon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pipemon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pipemon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 4883ec20 488bf9 4c8d0df8c50000 b903000000 4c8d05e4c50000 }
            // n = 6, score = 100
            //   57                   | mov                 ecx, ecx
            //   4883ec20             | inc                 esp
            //   488bf9               | lea                 eax, [edx + 2]
            //   4c8d0df8c50000       | dec                 eax
            //   b903000000           | lea                 ecx, [0xfffea411]
            //   4c8d05e4c50000       | dec                 eax

        $sequence_1 = { 488bec 4883ec40 488d45e8 48894de8 488945f0 488d15c0a80000 b805000000 }
            // n = 7, score = 100
            //   488bec               | lea                 ecx, [0xc5a9]
            //   4883ec40             | mov                 ecx, 4
            //   488d45e8             | dec                 esp
            //   48894de8             | lea                 eax, [0xc595]
            //   488945f0             | dec                 eax
            //   488d15c0a80000       | mov                 dword ptr [esp + 0x20], ebx
            //   b805000000           | push                esi

        $sequence_2 = { 488d0d620b0000 e8???????? e8???????? 488d15794a0100 488d0d524a0100 }
            // n = 5, score = 100
            //   488d0d620b0000       | je                  0xdaf
            //   e8????????           |                     
            //   e8????????           |                     
            //   488d15794a0100       | cmp                 ecx, dword ptr [ebx + 0x20]
            //   488d0d524a0100       | jae                 0xde6

        $sequence_3 = { 81f95d68fa3c 0f85a3000000 4d8b5620 41bfffff0000 }
            // n = 4, score = 100
            //   81f95d68fa3c         | dec                 eax
            //   0f85a3000000         | test                eax, eax
            //   4d8b5620             | dec                 eax
            //   41bfffff0000         | lea                 ebx, [edi + ecx*8]

        $sequence_4 = { 895128 488d0d6fa90000 488b45d8 488908 }
            // n = 4, score = 100
            //   895128               | dec                 eax
            //   488d0d6fa90000       | lea                 ecx, [esp + 0x50]
            //   488b45d8             | dec                 eax
            //   488908               | mov                 dword ptr [esp + 0x40], ecx

        $sequence_5 = { 4533ff 443b432c 723d 450fb75a06 410fb7d7 66453bfb 732b }
            // n = 7, score = 100
            //   4533ff               | lea                 ebp, [eax - 0x9c8]
            //   443b432c             | dec                 eax
            //   723d                 | sub                 esp, 0xaa0
            //   450fb75a06           | dec                 eax
            //   410fb7d7             | mov                 dword ptr [ebp - 0x78], 0xfffffffe
            //   66453bfb             | dec                 eax
            //   732b                 | mov                 dword ptr [eax + 0x10], ebx

        $sequence_6 = { 4c8d442458 488d4c2438 e8???????? 4c8d4820 4889442420 4c8bc3 488d5588 }
            // n = 7, score = 100
            //   4c8d442458           | dec                 eax
            //   488d4c2438           | lea                 edx, [0x1dbe7]
            //   e8????????           |                     
            //   4c8d4820             | dec                 eax
            //   4889442420           | lea                 ecx, [esp + 0x20]
            //   4c8bc3               | int3                
            //   488d5588             | dec                 eax

        $sequence_7 = { 488bd8 483b5c2440 e9???????? c644243000 488d8570060000 4889442428 4c8d4c2450 }
            // n = 7, score = 100
            //   488bd8               | inc                 ecx
            //   483b5c2440           | mov                 eax, 0x200
            //   e9????????           |                     
            //   c644243000           | dec                 eax
            //   488d8570060000       | mov                 dword ptr [esp + 0x68], edx
            //   4889442428           | dec                 eax
            //   4c8d4c2450           | mov                 esi, dword ptr [ebp + 0x878]

        $sequence_8 = { 48894a08 488d4c2420 e8???????? 488d05ce3a0100 488903 488bc3 }
            // n = 6, score = 100
            //   48894a08             | mov                 eax, ebx
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     
            //   488d05ce3a0100       | lea                 edx, [0x1ef90]
            //   488903               | dec                 eax
            //   488bc3               | lea                 ecx, [ebp + 0x880]

        $sequence_9 = { cc 4883ec48 488bd1 488d4c2420 e8???????? 488d15dcdc0100 }
            // n = 6, score = 100
            //   cc                   | lea                 eax, [0x13c3b]
            //   4883ec48             | or                  eax, 0xffffffff
            //   488bd1               | lock xadd           dword ptr [ecx], eax
            //   488d4c2420           | cmp                 eax, 1
            //   e8????????           |                     
            //   488d15dcdc0100       | jne                 0x292

    condition:
        7 of them and filesize < 389120
}