rule win_pkybot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pkybot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pkybot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf0 eb02 33f6 8b4704 0590000000 894620 }
            // n = 6, score = 1400
            //   8bf0                 | mov                 esi, eax
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   0590000000           | add                 eax, 0x90
            //   894620               | mov                 dword ptr [esi + 0x20], eax

        $sequence_1 = { 33c0 e9???????? 53 6a10 ff7510 8d45f0 }
            // n = 6, score = 1400
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   53                   | push                ebx
            //   6a10                 | push                0x10
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_2 = { 53 ff7004 ff30 6aff }
            // n = 4, score = 1400
            //   53                   | push                ebx
            //   ff7004               | push                dword ptr [eax + 4]
            //   ff30                 | push                dword ptr [eax]
            //   6aff                 | push                -1

        $sequence_3 = { 7407 46 8a06 84c0 79eb 8bc6 }
            // n = 6, score = 1400
            //   7407                 | je                  9
            //   46                   | inc                 esi
            //   8a06                 | mov                 al, byte ptr [esi]
            //   84c0                 | test                al, al
            //   79eb                 | jns                 0xffffffed
            //   8bc6                 | mov                 eax, esi

        $sequence_4 = { 7510 8b4e04 21413c c741300d000000 }
            // n = 4, score = 1400
            //   7510                 | jne                 0x12
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   21413c               | and                 dword ptr [ecx + 0x3c], eax
            //   c741300d000000       | mov                 dword ptr [ecx + 0x30], 0xd

        $sequence_5 = { 6801000040 ff7510 ff750c e8???????? }
            // n = 4, score = 1400
            //   6801000040           | push                0x40000001
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     

        $sequence_6 = { 7503 8b7104 83c10c e8???????? 50 8bce }
            // n = 6, score = 1400
            //   7503                 | jne                 5
            //   8b7104               | mov                 esi, dword ptr [ecx + 4]
            //   83c10c               | add                 ecx, 0xc
            //   e8????????           |                     
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 8b07 8bcf ff5008 6a2c e8???????? }
            // n = 5, score = 1400
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8bcf                 | mov                 ecx, edi
            //   ff5008               | call                dword ptr [eax + 8]
            //   6a2c                 | push                0x2c
            //   e8????????           |                     

        $sequence_8 = { 8b4008 eb08 e8???????? 59 }
            // n = 4, score = 1400
            //   8b4008               | mov                 eax, dword ptr [eax + 8]
            //   eb08                 | jmp                 0xa
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { 56 ff7510 ff750c ff7508 ff15???????? 85c0 }
            // n = 6, score = 1400
            //   56                   | push                esi
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 204800
}