rule win_play_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.play."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.play"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 7ff1 eb1d 8d85b1feffff 03c1 50 }
            // n = 6, score = 100
            //   85c9                 | test                ecx, ecx
            //   7ff1                 | jg                  0xfffffff3
            //   eb1d                 | jmp                 0x1f
            //   8d85b1feffff         | lea                 eax, [ebp - 0x14f]
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax

        $sequence_1 = { 0f1005???????? 8945ac b854040000 6689856cffffff b8e0690000 0f114588 052496ffff }
            // n = 7, score = 100
            //   0f1005????????       |                     
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   b854040000           | mov                 eax, 0x454
            //   6689856cffffff       | mov                 word ptr [ebp - 0x94], ax
            //   b8e0690000           | mov                 eax, 0x69e0
            //   0f114588             | movups              xmmword ptr [ebp - 0x78], xmm0
            //   052496ffff           | add                 eax, 0xffff9624

        $sequence_2 = { 898518feffff b879180000 0f118594feffff 898534ffffff f30f7e05???????? a1???????? 660fd68500ffffff }
            // n = 7, score = 100
            //   898518feffff         | mov                 dword ptr [ebp - 0x1e8], eax
            //   b879180000           | mov                 eax, 0x1879
            //   0f118594feffff       | movups              xmmword ptr [ebp - 0x16c], xmm0
            //   898534ffffff         | mov                 dword ptr [ebp - 0xcc], eax
            //   f30f7e05????????     |                     
            //   a1????????           |                     
            //   660fd68500ffffff     | movq                qword ptr [ebp - 0x100], xmm0

        $sequence_3 = { 02c0 02c2 888596feffff b9???????? e8???????? 8a85acfeffff }
            // n = 6, score = 100
            //   02c0                 | add                 al, al
            //   02c2                 | add                 al, dl
            //   888596feffff         | mov                 byte ptr [ebp - 0x16a], al
            //   b9????????           |                     
            //   e8????????           |                     
            //   8a85acfeffff         | mov                 al, byte ptr [ebp - 0x154]

        $sequence_4 = { 8a857cfcffff fec0 c745e43d000000 0245fd 8845ff 888521ffffff b83e000000 }
            // n = 7, score = 100
            //   8a857cfcffff         | mov                 al, byte ptr [ebp - 0x384]
            //   fec0                 | inc                 al
            //   c745e43d000000       | mov                 dword ptr [ebp - 0x1c], 0x3d
            //   0245fd               | add                 al, byte ptr [ebp - 3]
            //   8845ff               | mov                 byte ptr [ebp - 1], al
            //   888521ffffff         | mov                 byte ptr [ebp - 0xdf], al
            //   b83e000000           | mov                 eax, 0x3e

        $sequence_5 = { bbb410624c 8b0d???????? e8???????? 6aff ff75e8 ffd0 }
            // n = 6, score = 100
            //   bbb410624c           | mov                 ebx, 0x4c6210b4
            //   8b0d????????         |                     
            //   e8????????           |                     
            //   6aff                 | push                -1
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ffd0                 | call                eax

        $sequence_6 = { e8???????? 33d2 8b4df4 f7f6 8bc2 8945e4 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   f7f6                 | div                 esi
            //   8bc2                 | mov                 eax, edx
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax

        $sequence_7 = { 8955f8 894dfc e8???????? 8b0d???????? 33d2 }
            // n = 5, score = 100
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   33d2                 | xor                 edx, edx

        $sequence_8 = { 889591feffff 888dc9feffff 888d81feffff b920000000 c60000 }
            // n = 5, score = 100
            //   889591feffff         | mov                 byte ptr [ebp - 0x16f], dl
            //   888dc9feffff         | mov                 byte ptr [ebp - 0x137], cl
            //   888d81feffff         | mov                 byte ptr [ebp - 0x17f], cl
            //   b920000000           | mov                 ecx, 0x20
            //   c60000               | mov                 byte ptr [eax], 0

        $sequence_9 = { e8???????? 2467 0fa1 ee d5d8 e9???????? 8c9f381b40b1 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   2467                 | and                 al, 0x67
            //   0fa1                 | pop                 fs
            //   ee                   | out                 dx, al
            //   d5d8                 | aad                 0xd8
            //   e9????????           |                     
            //   8c9f381b40b1         | mov                 word ptr [edi - 0x4ebfe4c8], ds

    condition:
        7 of them and filesize < 389120
}