rule win_playwork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.playwork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.playwork"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 59 8945f0 0f84d4010000 8d4df4 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   59                   | pop                 ecx
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   0f84d4010000         | je                  0x1da
            //   8d4df4               | lea                 ecx, [ebp - 0xc]

        $sequence_1 = { eb02 32db 8ac3 8acb c0e807 d0e1 }
            // n = 6, score = 100
            //   eb02                 | jmp                 4
            //   32db                 | xor                 bl, bl
            //   8ac3                 | mov                 al, bl
            //   8acb                 | mov                 cl, bl
            //   c0e807               | shr                 al, 7
            //   d0e1                 | shl                 cl, 1

        $sequence_2 = { 57 8d857ce9ffff 56 50 6800004004 8d4de0 ff7510 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d857ce9ffff         | lea                 eax, [ebp - 0x1684]
            //   56                   | push                esi
            //   50                   | push                eax
            //   6800004004           | push                0x4400000
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_3 = { 8bd0 8d85e8afffff 50 8955ec ffd3 8b4dec }
            // n = 6, score = 100
            //   8bd0                 | mov                 edx, eax
            //   8d85e8afffff         | lea                 eax, [ebp - 0x5018]
            //   50                   | push                eax
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   ffd3                 | call                ebx
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_4 = { 53 50 8d4510 6a08 50 57 ffd6 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8d4510               | lea                 eax, [ebp + 0x10]
            //   6a08                 | push                8
            //   50                   | push                eax
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_5 = { c1eb18 330c95344b3f00 8b55e0 8b349d34573f00 c1ea10 }
            // n = 5, score = 100
            //   c1eb18               | shr                 ebx, 0x18
            //   330c95344b3f00       | xor                 ecx, dword ptr [edx*4 + 0x3f4b34]
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8b349d34573f00       | mov                 esi, dword ptr [ebx*4 + 0x3f5734]
            //   c1ea10               | shr                 edx, 0x10

        $sequence_6 = { 50 8d85b8ebffff 68???????? 50 e8???????? 83c444 8d85b8ebffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d85b8ebffff         | lea                 eax, [ebp - 0x1448]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c444               | add                 esp, 0x44
            //   8d85b8ebffff         | lea                 eax, [ebp - 0x1448]

        $sequence_7 = { e8???????? 8b45fc 83c40c 668b4008 50 ff15???????? 0fb7c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c40c               | add                 esp, 0xc
            //   668b4008             | mov                 ax, word ptr [eax + 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax

        $sequence_8 = { a4 284405c8 40 83f822 7cf6 }
            // n = 5, score = 100
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   284405c8             | sub                 byte ptr [ebp + eax - 0x38], al
            //   40                   | inc                 eax
            //   83f822               | cmp                 eax, 0x22
            //   7cf6                 | jl                  0xfffffff8

        $sequence_9 = { 8bce 8975e8 c1e918 8b3c8d34573f00 8b4de0 333c9534533f00 }
            // n = 6, score = 100
            //   8bce                 | mov                 ecx, esi
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   c1e918               | shr                 ecx, 0x18
            //   8b3c8d34573f00       | mov                 edi, dword ptr [ecx*4 + 0x3f5734]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   333c9534533f00       | xor                 edi, dword ptr [edx*4 + 0x3f5334]

    condition:
        7 of them and filesize < 360448
}