rule win_polyglotduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.polyglotduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polyglotduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bcb 4803f7 e8???????? eb38 488d0d190f0100 e8???????? b905000000 }
            // n = 7, score = 100
            //   488bcb               | lea                 ecx, [0xd21c]
            //   4803f7               | dec                 esp
            //   e8????????           |                     
            //   eb38                 | mov                 ecx, ebx
            //   488d0d190f0100       | mov                 edx, 0x75e
            //   e8????????           |                     
            //   b905000000           | dec                 eax

        $sequence_1 = { f6431840 4c8d0d0269ffff 0f85a5000000 488bcb e8???????? 488d15fdd30000 413bc6 }
            // n = 7, score = 100
            //   f6431840             | dec                 ebp
            //   4c8d0d0269ffff       | cmp                 ecx, edx
            //   0f85a5000000         | jl                  0xba9
            //   488bcb               | inc                 eax
            //   e8????????           |                     
            //   488d15fdd30000       | sete                bh
            //   413bc6               | dec                 eax

        $sequence_2 = { 4c8bf8 e8???????? 488d0d86d20000 4c8bf0 e8???????? 488d0d7fd20000 4c8be8 }
            // n = 7, score = 100
            //   4c8bf8               | inc                 ecx
            //   e8????????           |                     
            //   488d0d86d20000       | mov                 esp, 0xfde9
            //   4c8bf0               | xor                 edx, edx
            //   e8????????           |                     
            //   488d0d7fd20000       | inc                 ebp
            //   4c8be8               | mov                 ecx, ebp

        $sequence_3 = { 48894608 4803c8 e8???????? 8b54244c }
            // n = 4, score = 100
            //   48894608             | inc                 ecx
            //   4803c8               | mov                 ecx, esp
            //   e8????????           |                     
            //   8b54244c             | dec                 ecx

        $sequence_4 = { 8a4f02 4c8bf0 884803 488bcf e8???????? 8b06 }
            // n = 6, score = 100
            //   8a4f02               | dec                 eax
            //   4c8bf0               | mov                 edi, eax
            //   884803               | je                  0x157c
            //   488bcf               | dec                 esp
            //   e8????????           |                     
            //   8b06                 | cmp                 dword ptr [esi + 0x48], esp

        $sequence_5 = { 4c8d0d35db0000 33c0 498bd1 448d4008 3b0a 742b ffc0 }
            // n = 7, score = 100
            //   4c8d0d35db0000       | inc                 edx
            //   33c0                 | mov                 byte ptr [ecx + eax + 0x164d0], al
            //   498bd1               | mov                 dword ptr [esp + 0x20], edi
            //   448d4008             | dec                 eax
            //   3b0a                 | mov                 ecx, esi
            //   742b                 | dec                 esp
            //   ffc0                 | mov                 esi, eax

        $sequence_6 = { ff15???????? 488b5c2430 488bcb 8d78fb ff15???????? 03c7 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   488b5c2430           | dec                 ebp
            //   488bcb               | mov                 eax, esi
            //   8d78fb               | dec                 ecx
            //   ff15????????         |                     
            //   03c7                 | neg                 edx

        $sequence_7 = { 498bd5 498bce ff15???????? 33ff }
            // n = 4, score = 100
            //   498bd5               | mov                 esi, eax
            //   498bce               | lea                 ecx, [ebp + 0x4e]
            //   ff15????????         |                     
            //   33ff                 | dec                 eax

        $sequence_8 = { 7e74 817d0063736de0 7528 48833d????????00 741e 488d0d79db0000 }
            // n = 6, score = 100
            //   7e74                 | mov                 dword ptr [esp + 0x38], ebx
            //   817d0063736de0       | inc                 esp
            //   7528                 | mov                 ebx, eax
            //   48833d????????00     |                     
            //   741e                 | test                eax, eax
            //   488d0d79db0000       | jne                 0x43b

        $sequence_9 = { e9???????? 488bca ff15???????? 83f847 75eb 488bcd ff15???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488bca               | dec                 eax
            //   ff15????????         |                     
            //   83f847               | lea                 edx, [0xf9ab]
            //   75eb                 | dec                 eax
            //   488bcd               | lea                 ecx, [esp + 0x70]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 222784
}