rule win_pony_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pony."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pony"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c6400200 c6400300 c6400400 c6400505 8d45f4 50 }
            // n = 6, score = 800
            //   c6400200             | mov                 byte ptr [eax + 2], 0
            //   c6400300             | mov                 byte ptr [eax + 3], 0
            //   c6400400             | mov                 byte ptr [eax + 4], 0
            //   c6400505             | mov                 byte ptr [eax + 5], 5
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax

        $sequence_1 = { 33f9 8d9c1f051d8804 035e18 c1c317 }
            // n = 4, score = 800
            //   33f9                 | xor                 edi, ecx
            //   8d9c1f051d8804       | lea                 ebx, [edi + ebx + 0x4881d05]
            //   035e18               | add                 ebx, dword ptr [esi + 0x18]
            //   c1c317               | rol                 ebx, 0x17

        $sequence_2 = { 7406 50 e8???????? c785dcf7ffff15000000 8d85d0f7ffff }
            // n = 5, score = 800
            //   7406                 | je                  8
            //   50                   | push                eax
            //   e8????????           |                     
            //   c785dcf7ffff15000000     | mov    dword ptr [ebp - 0x824], 0x15
            //   8d85d0f7ffff         | lea                 eax, [ebp - 0x830]

        $sequence_3 = { ff750c ff35???????? e8???????? 8945f4 6a00 ff7514 ff750c }
            // n = 7, score = 800
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_4 = { c1e002 31c2 89c8 c1e810 31d0 89c3 }
            // n = 6, score = 800
            //   c1e002               | shl                 eax, 2
            //   31c2                 | xor                 edx, eax
            //   89c8                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   31d0                 | xor                 eax, edx
            //   89c3                 | mov                 ebx, eax

        $sequence_5 = { 75ed 0fb646ff 83f808 7702 2bf0 2b7510 d1ee }
            // n = 7, score = 800
            //   75ed                 | jne                 0xffffffef
            //   0fb646ff             | movzx               eax, byte ptr [esi - 1]
            //   83f808               | cmp                 eax, 8
            //   7702                 | ja                  4
            //   2bf0                 | sub                 esi, eax
            //   2b7510               | sub                 esi, dword ptr [ebp + 0x10]
            //   d1ee                 | shr                 esi, 1

        $sequence_6 = { 2bfb 83fb38 720e 03fb b840000000 2bc3 03f8 }
            // n = 7, score = 800
            //   2bfb                 | sub                 edi, ebx
            //   83fb38               | cmp                 ebx, 0x38
            //   720e                 | jb                  0x10
            //   03fb                 | add                 edi, ebx
            //   b840000000           | mov                 eax, 0x40
            //   2bc3                 | sub                 eax, ebx
            //   03f8                 | add                 edi, eax

        $sequence_7 = { 6800fa0000 ff75f4 ff7508 e8???????? 85c0 0f8430010000 ff75f4 }
            // n = 7, score = 800
            //   6800fa0000           | push                0xfa00
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8430010000         | je                  0x136
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_8 = { 68???????? e8???????? 898554ffffff 83bd54ffffff00 7445 83bd58ffffff14 723c }
            // n = 7, score = 800
            //   68????????           |                     
            //   e8????????           |                     
            //   898554ffffff         | mov                 dword ptr [ebp - 0xac], eax
            //   83bd54ffffff00       | cmp                 dword ptr [ebp - 0xac], 0
            //   7445                 | je                  0x47
            //   83bd58ffffff14       | cmp                 dword ptr [ebp - 0xa8], 0x14
            //   723c                 | jb                  0x3e

        $sequence_9 = { ff7518 e8???????? ff750c e8???????? d1e0 83c002 }
            // n = 6, score = 800
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   d1e0                 | shl                 eax, 1
            //   83c002               | add                 eax, 2

    condition:
        7 of them and filesize < 262144
}