rule win_poohmilk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poohmilk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poohmilk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 68???????? 8d95ecfdffff 52 }
            // n = 4, score = 200
            //   c3                   | ret                 
            //   68????????           |                     
            //   8d95ecfdffff         | lea                 edx, [ebp - 0x214]
            //   52                   | push                edx

        $sequence_1 = { 0f84de000000 3bf3 0f84d6000000 8b4110 0fb75704 }
            // n = 5, score = 200
            //   0f84de000000         | je                  0xe4
            //   3bf3                 | cmp                 esi, ebx
            //   0f84d6000000         | je                  0xdc
            //   8b4110               | mov                 eax, dword ptr [ecx + 0x10]
            //   0fb75704             | movzx               edx, word ptr [edi + 4]

        $sequence_2 = { 752c ff15???????? 6a05 6a00 6a00 }
            // n = 5, score = 200
            //   752c                 | jne                 0x2e
            //   ff15????????         |                     
            //   6a05                 | push                5
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_3 = { 0f84d3000000 33d2 668910 8d85d4f9ffff }
            // n = 4, score = 200
            //   0f84d3000000         | je                  0xd9
            //   33d2                 | xor                 edx, edx
            //   668910               | mov                 word ptr [eax], dx
            //   8d85d4f9ffff         | lea                 eax, [ebp - 0x62c]

        $sequence_4 = { 8b01 33ff 8995f4efffff 397e10 0f86cf000000 }
            // n = 5, score = 200
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   33ff                 | xor                 edi, edi
            //   8995f4efffff         | mov                 dword ptr [ebp - 0x100c], edx
            //   397e10               | cmp                 dword ptr [esi + 0x10], edi
            //   0f86cf000000         | jbe                 0xd5

        $sequence_5 = { 83ffff 0f8456ffffff 8b95d4fbffff 6a00 8d8dd0fbffff 51 }
            // n = 6, score = 200
            //   83ffff               | cmp                 edi, -1
            //   0f8456ffffff         | je                  0xffffff5c
            //   8b95d4fbffff         | mov                 edx, dword ptr [ebp - 0x42c]
            //   6a00                 | push                0
            //   8d8dd0fbffff         | lea                 ecx, [ebp - 0x430]
            //   51                   | push                ecx

        $sequence_6 = { 8bd1 03d7 c785ecefffff00000000 1385ecefffff 89bde8efffff }
            // n = 5, score = 200
            //   8bd1                 | mov                 edx, ecx
            //   03d7                 | add                 edx, edi
            //   c785ecefffff00000000     | mov    dword ptr [ebp - 0x1014], 0
            //   1385ecefffff         | adc                 eax, dword ptr [ebp - 0x1014]
            //   89bde8efffff         | mov                 dword ptr [ebp - 0x1018], edi

        $sequence_7 = { 8b8570d2ffff 8b5038 837a3400 7513 8b8d84d2ffff 8b5028 }
            // n = 6, score = 200
            //   8b8570d2ffff         | mov                 eax, dword ptr [ebp - 0x2d90]
            //   8b5038               | mov                 edx, dword ptr [eax + 0x38]
            //   837a3400             | cmp                 dword ptr [edx + 0x34], 0
            //   7513                 | jne                 0x15
            //   8b8d84d2ffff         | mov                 ecx, dword ptr [ebp - 0x2d7c]
            //   8b5028               | mov                 edx, dword ptr [eax + 0x28]

        $sequence_8 = { 40 80b9b075410000 74e8 8a13 0fb6ca 0fbe89b0754100 }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   80b9b075410000       | cmp                 byte ptr [ecx + 0x4175b0], 0
            //   74e8                 | je                  0xffffffea
            //   8a13                 | mov                 dl, byte ptr [ebx]
            //   0fb6ca               | movzx               ecx, dl
            //   0fbe89b0754100       | movsx               ecx, byte ptr [ecx + 0x4175b0]

        $sequence_9 = { 33c0 894610 894614 894618 89461c 8b4620 8b4f28 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   894618               | mov                 dword ptr [esi + 0x18], eax
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   8b4f28               | mov                 ecx, dword ptr [edi + 0x28]

    condition:
        7 of them and filesize < 245760
}