rule win_poortry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poortry."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poortry"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 80c2d6 f6da 41d2db 80f283 4d63d8 4181e3cc593b0e 41c0c35a }
            // n = 7, score = 100
            //   80c2d6               | inc                 ecx
            //   f6da                 | mov                 ebx, dword ptr [ecx]
            //   41d2db               | dec                 ecx
            //   80f283               | add                 ecx, 4
            //   4d63d8               | inc                 ecx
            //   4181e3cc593b0e       | test                ch, 0xe4
            //   41c0c35a             | mov                 bx, 0x7bab

        $sequence_1 = { 9c 418f00 450fbbf2 458b11 664585f0 66f7c16046 4181fd7b733a3c }
            // n = 7, score = 100
            //   9c                   | inc                 ecx
            //   418f00               | test                esp, 0x206b3a4b
            //   450fbbf2             | dec                 ecx
            //   458b11               | add                 ecx, 4
            //   664585f0             | inc                 esp
            //   66f7c16046           | test                bl, al
            //   4181fd7b733a3c       | mov                 dword ptr [eax], edx

        $sequence_2 = { 41d3d3 312c24 66450fabe3 410fbafb10 415b 3ac5 f9 }
            // n = 7, score = 100
            //   41d3d3               | add                 edx, 0x177e1735
            //   312c24               | inc                 ecx
            //   66450fabe3           | test                ch, 0x8b
            //   410fbafb10           | inc                 ecx
            //   415b                 | neg                 edx
            //   3ac5                 | inc                 ecx
            //   f9                   | test                bh, 0xea

        $sequence_3 = { 0fbfdb 66440fb3fa 418ad6 410fb618 48d3ea 66d3c2 d2fe }
            // n = 7, score = 100
            //   0fbfdb               | btr                 eax, 0xff
            //   66440fb3fa           | lahf                
            //   418ad6               | add                 dl, 7
            //   410fb618             | ror                 dl, 1
            //   48d3ea               | dec                 eax
            //   66d3c2               | neg                 eax
            //   d2fe                 | inc                 ecx

        $sequence_4 = { 480fbfed f8 44311c24 400f9ec5 5d f8 4d63db }
            // n = 7, score = 100
            //   480fbfed             | dec                 ecx
            //   f8                   | add                 ecx, 4
            //   44311c24             | dec                 ecx
            //   400f9ec5             | test                edx, 0x6d6c2530
            //   5d                   | inc                 ebp
            //   f8                   | mov                 dword ptr [eax], edx
            //   4d63db               | adc                 ebp, 0x2d11458f

        $sequence_5 = { 4d0fb7e7 448ae7 415c 66450fbeea 66410fcd 490fbfed 415d }
            // n = 7, score = 100
            //   4d0fb7e7             | bswap               edx
            //   448ae7               | inc                 edx
            //   415c                 | not                 edx
            //   66450fbeea           | dec                 ecx
            //   66410fcd             | add                 eax, 4
            //   490fbfed             | inc                 sp
            //   415d                 | cmp                 eax, edi

        $sequence_6 = { 0fca 41f6c185 56 311424 f8 5e 4863d2 }
            // n = 7, score = 100
            //   0fca                 | pop                 edx
            //   41f6c185             | inc                 ecx
            //   56                   | not                 al
            //   311424               | inc                 ecx
            //   f8                   | pop                 ebx
            //   5e                   | inc                 bp
            //   4863d2               | movsx               eax, bl

        $sequence_7 = { 66f7de 5e 4584c3 f9 4c3bc0 4d63d2 4d85eb }
            // n = 7, score = 100
            //   66f7de               | inc                 ecx
            //   5e                   | setns               dh
            //   4584c3               | pop                 esi
            //   f9                   | cwd                 
            //   4c3bc0               | pop                 esi
            //   4d63d2               | pop                 ebx
            //   4d85eb               | pop                 ebp

        $sequence_8 = { 488b11 40f6c6b8 498912 4863d7 411ad2 4881ef04000000 66c1daa9 }
            // n = 7, score = 100
            //   488b11               | bsf                 edi, ebx
            //   40f6c6b8             | dec                 eax
            //   498912               | add                 ebp, 2
            //   4863d7               | inc                 ecx
            //   411ad2               | movzx               edi, byte ptr [eax]
            //   4881ef04000000       | inc                 bp
            //   66c1daa9             | movsx               ecx, cl

        $sequence_9 = { f5 55 4080e5d9 4881cda16c1a19 40d2d5 311424 66440fbbfd }
            // n = 7, score = 100
            //   f5                   | pushfd              
            //   55                   | inc                 ecx
            //   4080e5d9             | pop                 dword ptr [eax]
            //   4881cda16c1a19       | inc                 esp
            //   40d2d5               | bt                  eax, esi
            //   311424               | mov                 word ptr [esi + 0x44], fs
            //   66440fbbfd           | and                 ecx, edx

    condition:
        7 of them and filesize < 8078336
}