rule win_portstarter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.portstarter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.portstarter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8b9c24a8010000 4c89442448 7507 4d8b4c2408 }
            // n = 4, score = 200
            //   4c8b9c24a8010000     | lea                 ecx, [0x1c06e3]
            //   4c89442448           | mov                 eax, dword ptr [esp + 0x2c]
            //   7507                 | mov                 dword ptr [esp + 0x38], eax
            //   4d8b4c2408           | dec                 eax

        $sequence_1 = { 4c8b8c24d8000000 4d8b5918 4d8b6318 4d8b6b08 4d8b1b 4d39e5 0f8645050000 }
            // n = 7, score = 200
            //   4c8b8c24d8000000     | mov                 dword ptr [esp + 0x28], eax
            //   4d8b5918             | dec                 esp
            //   4d8b6318             | lea                 eax, [0x2032]
            //   4d8b6b08             | mov                 dword ptr [esp + 0x24], eax
            //   4d8b1b               | dec                 eax
            //   4d39e5               | mov                 dword ptr [esp + 0x28], 0
            //   0f8645050000         | inc                 ecx

        $sequence_2 = { 4c8b9c24b8000000 498d3c03 488b842410010000 4c89d1 4c89c6 90 }
            // n = 6, score = 200
            //   4c8b9c24b8000000     | dec                 eax
            //   498d3c03             | add                 ecx, eax
            //   488b842410010000     | dec                 eax
            //   4c89d1               | mov                 eax, ecx
            //   4c89c6               | mov                 dword ptr [esp + 0x38], eax
            //   90                   | dec                 eax

        $sequence_3 = { 4c8b942468010000 4d21fa 4d09d5 49c1ed3f 4f8d1404 4d01ea }
            // n = 6, score = 200
            //   4c8b942468010000     | lea                 ecx, [esp + 0x20]
            //   4d21fa               | dec                 eax
            //   4d09d5               | mov                 dword ptr [esp + 0x28], eax
            //   49c1ed3f             | dec                 eax
            //   4f8d1404             | mov                 dword ptr [esp + 0x28], 0
            //   4d01ea               | inc                 ecx

        $sequence_4 = { 4c8d6424f0 4d3b6610 0f8660030000 4881ec90000000 4889ac2488000000 488dac2488000000 }
            // n = 6, score = 200
            //   4c8d6424f0           | mov                 eax, dword ptr [esp + 0x58]
            //   4d3b6610             | mov                 dword ptr [esp + 0x24], eax
            //   0f8660030000         | dec                 eax
            //   4881ec90000000       | mov                 dword ptr [esp + 0x28], 0
            //   4889ac2488000000     | inc                 ecx
            //   488dac2488000000     | mov                 eax, 0x1bde00

        $sequence_5 = { 4c8b9424d8000000 4c8ba42400010000 4c896310 4c895318 }
            // n = 4, score = 200
            //   4c8b9424d8000000     | lea                 edx, [0x2fd0]
            //   4c8ba42400010000     | dec                 eax
            //   4c896310             | lea                 ecx, [esp + 0x20]
            //   4c895318             | dec                 eax

        $sequence_6 = { 4c8b9424d8000000 4d39e2 0f8745010000 0f8734010000 }
            // n = 4, score = 200
            //   4c8b9424d8000000     | dec                 eax
            //   4d39e2               | add                 ecx, eax
            //   0f8745010000         | mov                 dword ptr [esp + 0x38], eax
            //   0f8734010000         | dec                 eax

        $sequence_7 = { 4c8d6424d0 4d3b6610 0f8610020000 4881ecb0000000 }
            // n = 4, score = 200
            //   4c8d6424d0           | mov                 dword ptr [esp + 0x28], 0
            //   4d3b6610             | inc                 ecx
            //   0f8610020000         | mov                 eax, 0x1bde00
            //   4881ecb0000000       | dec                 eax

        $sequence_8 = { 41b800de1b00 488d15d02f0000 488d4c2420 e8???????? }
            // n = 4, score = 100
            //   41b800de1b00         | inc                 ecx
            //   488d15d02f0000       | mov                 eax, 0x1bde00
            //   488d4c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 4863442430 486bc010 488d0de3061c00 4803c8 }
            // n = 4, score = 100
            //   4863442430           | dec                 eax
            //   486bc010             | lea                 ecx, [esp + 0x20]
            //   488d0de3061c00       | dec                 eax
            //   4803c8               | mov                 dword ptr [esp + 0x28], eax

        $sequence_10 = { 4883ec48 8b442458 89442424 48c744242800000000 41b800de1b00 }
            // n = 5, score = 100
            //   4883ec48             | dec                 eax
            //   8b442458             | mov                 eax, ecx
            //   89442424             | dec                 eax
            //   48c744242800000000     | arpl    word ptr [esp + 0x34], cx
            //   41b800de1b00         | dec                 eax

        $sequence_11 = { 488d0de3061c00 4803c8 488bc1 48634c2434 }
            // n = 4, score = 100
            //   488d0de3061c00       | add                 ecx, eax
            //   4803c8               | dec                 eax
            //   488bc1               | mov                 eax, ecx
            //   48634c2434           | dec                 eax

    condition:
        7 of them and filesize < 14216192
}