rule win_poslurp_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poslurp."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poslurp"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883f8ff 743d 448d4f02 4533c0 33d2 488bc8 }
            // n = 6, score = 100
            //   4883f8ff             | dec                 eax
            //   743d                 | sub                 esp, 0x20
            //   448d4f02             | dec                 eax
            //   4533c0               | mov                 ebx, ecx
            //   33d2                 | jne                 0x462
            //   488bc8               | push                edi

        $sequence_1 = { 3905???????? 7309 33c9 ff15???????? }
            // n = 4, score = 100
            //   3905????????         |                     
            //   7309                 | je                  0x4b
            //   33c9                 | xor                 eax, eax
            //   ff15????????         |                     

        $sequence_2 = { 44891d???????? eb0b 6689445420 41ffc0 48ffc2 4883c9ff 33c0 }
            // n = 7, score = 100
            //   44891d????????       |                     
            //   eb0b                 | dec                 eax
            //   6689445420           | lea                 edi, [esp + 0x38]
            //   41ffc0               | dec                 eax
            //   48ffc2               | mov                 esi, ebp
            //   4883c9ff             | mov                 ecx, 0x20
            //   33c0                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_3 = { 48f7d1 4883e901 7458 448b0d???????? }
            // n = 4, score = 100
            //   48f7d1               | test                edi, eax
            //   4883e901             | dec                 eax
            //   7458                 | test                eax, eax
            //   448b0d????????       |                     

        $sequence_4 = { 4c8bf0 488bf8 33c0 f3aa 498bce 488bd5 }
            // n = 6, score = 100
            //   4c8bf0               | inc                 sp
            //   488bf8               | mov                 dword ptr [esp + 0x5e], eax
            //   33c0                 | lea                 edx, [ebx + 8]
            //   f3aa                 | inc                 ecx
            //   498bce               | mov                 ebp, 0x68
            //   488bd5               | inc                 ecx

        $sequence_5 = { 740e 0f1f4000 488b1b 66837b3818 }
            // n = 4, score = 100
            //   740e                 | mov                 eax, 0x50
            //   0f1f4000             | dec                 eax
            //   488b1b               | mov                 edi, ecx
            //   66837b3818           | mov                 ebx, eax

        $sequence_6 = { ff15???????? 4883f830 0f85b3000000 817c245000100000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   4883f830             | dec                 esp
            //   0f85b3000000         | lea                 esp, [ebp - 1]
            //   817c245000100000     | xor                 ebx, ebx

        $sequence_7 = { 4d897b08 4d897bc8 8b7c0850 4c8bf2 488be9 4d897ba0 }
            // n = 6, score = 100
            //   4d897b08             | dec                 eax
            //   4d897bc8             | mov                 ecx, edi
            //   8b7c0850             | dec                 esp
            //   4c8bf2               | mov                 esp, dword ptr [esp + 0x50]
            //   488be9               | dec                 eax
            //   4d897ba0             | mov                 ebp, dword ptr [esp + 0x58]

        $sequence_8 = { 0f84d5000000 6666660f1f840000000000 0fb703 ffc9 83e830 }
            // n = 5, score = 100
            //   0f84d5000000         | mov                 word ptr [esp + 0x76], ax
            //   6666660f1f840000000000     | mov    word ptr [esp + 0x76], ax
            //   0fb703               | mov                 eax, 0x78
            //   ffc9                 | dec                 eax
            //   83e830               | mov                 ebp, edx

        $sequence_9 = { ffce 488bd5 48d1f9 8bfb 85c9 }
            // n = 5, score = 100
            //   ffce                 | xor                 edx, edx
            //   488bd5               | dec                 eax
            //   48d1f9               | mov                 ecx, ebx
            //   8bfb                 | dec                 eax
            //   85c9                 | mov                 ecx, ebp

    condition:
        7 of them and filesize < 50176
}