rule win_postnaptea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.postnaptea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.postnaptea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? ffd0 448bc0 488d542430 488bb590000000 488bce e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ffd0                 | mov                 dword ptr [ebp + 0x44], 0xf537
            //   448bc0               | dec                 eax
            //   488d542430           | mov                 edx, esi
            //   488bb590000000       | dec                 ecx
            //   488bce               | mov                 ecx, esp
            //   e8????????           |                     

        $sequence_1 = { c745c8d4f6ccf6 41bf60090000 c745cc95f695f6 c745d086f6cdf6 c745d4c6f6c7f6 660f1f840000000000 4863c2 }
            // n = 7, score = 100
            //   c745c8d4f6ccf6       | dec                 eax
            //   41bf60090000         | mov                 dword ptr [esp + 0x38], edx
            //   c745cc95f695f6       | dec                 esp
            //   c745d086f6cdf6       | mov                 dword ptr [esp + 0x40], eax
            //   c745d4c6f6c7f6       | xor                 ebp, ebp
            //   660f1f840000000000     | mov    dword ptr [ecx], ebp
            //   4863c2               | mov                 dword ptr [ecx + 0x10], ebp

        $sequence_2 = { c785060800000af50cf5 c7850a08000012f50ef5 c7850e08000009f505f5 c7851208000003f511f5 c7851608000009f54df5 c7851a0800001af507f5 c7851e08000015f551f5 }
            // n = 7, score = 100
            //   c785060800000af50cf5     | mov    dword ptr [ecx + 0x10], edi
            //   c7850a08000012f50ef5     | dec    eax
            //   c7850e08000009f505f5     | mov    dword ptr [esp + 0x1c0], ebx
            //   c7851208000003f511f5     | dec    eax
            //   c7851608000009f54df5     | xor    eax, esp
            //   c7851a0800001af507f5     | dec    eax
            //   c7851e08000015f551f5     | mov    dword ptr [ebp + 0x70], eax

        $sequence_3 = { c7459418f513f5 c7459819f51bf5 c7459c5ff5baf5 c745a0a1f50000 4533c0 418bd0 660f1f840000000000 }
            // n = 7, score = 100
            //   c7459418f513f5       | mov                 edx, eax
            //   c7459819f51bf5       | call                eax
            //   c7459c5ff5baf5       | mov                 edx, eax
            //   c745a0a1f50000       | dec                 eax
            //   4533c0               | lea                 ecx, [ebp + 0xc0]
            //   418bd0               | nop                 
            //   660f1f840000000000     | dec    eax

        $sequence_4 = { e8???????? 0fb64b08 0fb7430a 663b4509 7416 84c9 750c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb64b08             | dec                 eax
            //   0fb7430a             | mov                 ecx, dword ptr [edi + 0x48]
            //   663b4509             | dec                 eax
            //   7416                 | sub                 ecx, dword ptr [edi + 0x40]
            //   84c9                 | dec                 eax
            //   750c                 | sar                 ecx, 5

        $sequence_5 = { c744247c01f516f5 c7458018f515f5 c7458453f517f5 c745881af518f5 c7458c03f51df5 c7459017f50ef5 c7459408f55cf5 }
            // n = 7, score = 100
            //   c744247c01f516f5     | jne                 0x1f58
            //   c7458018f515f5       | xor                 edx, edx
            //   c7458453f517f5       | mov                 ecx, 0x5056df37
            //   c745881af518f5       | dec                 eax
            //   c7458c03f51df5       | test                eax, eax
            //   c7459017f50ef5       | jne                 0x1bf6
            //   c7459408f55cf5       | dec                 eax

        $sequence_6 = { c7451830f51bf5 c7451c0bf5e8f5 c74520eef5e6f5 c74524a3f5e1f5 c74528fdf5e3f5 c7452ce4f5fdf5 c74530fdf5e3f5 }
            // n = 7, score = 100
            //   c7451830f51bf5       | je                  0x1778
            //   c7451c0bf5e8f5       | mov                 eax, 0x4000
            //   c74520eef5e6f5       | dec                 eax
            //   c74524a3f5e1f5       | sub                 eax, ecx
            //   c74528fdf5e3f5       | dec                 eax
            //   c7452ce4f5fdf5       | mov                 dword ptr [ebp + 0x8d0], eax
            //   c74530fdf5e3f5       | jmp                 0x1782

        $sequence_7 = { ff15???????? 85c0 7498 83f857 7493 4533c0 418bc8 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7498                 | lea                 ecx, [0x48c7f]
            //   83f857               | dec                 eax
            //   7493                 | mov                 dword ptr [eax + 0x2c8], ecx
            //   4533c0               | dec                 eax
            //   418bc8               | lea                 ecx, [0x48c6e]

        $sequence_8 = { ffc3 41b401 488b0f 4885c9 7441 488b4138 4c3928 }
            // n = 7, score = 100
            //   ffc3                 | xor                 byte ptr [ecx], al
            //   41b401               | dec                 eax
            //   488b0f               | lea                 eax, [ebp - 0x60]
            //   4885c9               | dec                 esp
            //   7441                 | mov                 eax, ebx
            //   488b4138             | dec                 esp
            //   4c3928               | sub                 eax, eax

        $sequence_9 = { ff15???????? 4c8bf0 4885ff 0f84a90a0000 4885c0 0f84a00a0000 c74424400af532f5 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4c8bf0               | mov                 ecx, dword ptr [esi + 0x38]
            //   4885ff               | dec                 eax
            //   0f84a90a0000         | test                ecx, ecx
            //   4885c0               | je                  0xc93
            //   0f84a00a0000         | dec                 eax
            //   c74424400af532f5     | lea                 ecx, [0x50365]

    condition:
        7 of them and filesize < 2457600
}