rule win_powerpool_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.powerpool."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powerpool"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7412 8b04b0 50 e8???????? }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b04b0               | mov                 eax, dword ptr [eax + esi*4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_1 = { 7412 837de810 8b45d4 895de4 }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx

        $sequence_2 = { 895e64 33db 894e68 53 53 56 }
            // n = 6, score = 200
            //   895e64               | mov                 dword ptr [esi + 0x64], ebx
            //   33db                 | xor                 ebx, ebx
            //   894e68               | mov                 dword ptr [esi + 0x68], ecx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_3 = { 7412 8b4904 80e103 80f901 }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b4904               | mov                 ecx, dword ptr [ecx + 4]
            //   80e103               | and                 cl, 3
            //   80f901               | cmp                 cl, 1

        $sequence_4 = { 006711 40 0000 0303 }
            // n = 4, score = 200
            //   006711               | add                 byte ptr [edi + 0x11], ah
            //   40                   | inc                 eax
            //   0000                 | add                 byte ptr [eax], al
            //   0303                 | add                 eax, dword ptr [ebx]

        $sequence_5 = { 7412 6a00 e8???????? 84c0 7407 b802000000 5f }
            // n = 7, score = 200
            //   7412                 | je                  0x14
            //   6a00                 | push                0
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   b802000000           | mov                 eax, 2
            //   5f                   | pop                 edi

        $sequence_6 = { 7412 83e903 0f8515010000 c745dcfcae4400 }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   83e903               | sub                 ecx, 3
            //   0f8515010000         | jne                 0x11b
            //   c745dcfcae4400       | mov                 dword ptr [ebp - 0x24], 0x44aefc

        $sequence_7 = { 895e64 ff15???????? 8b4c2418 51 }
            // n = 4, score = 200
            //   895e64               | mov                 dword ptr [esi + 0x64], ebx
            //   ff15????????         |                     
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   51                   | push                ecx

        $sequence_8 = { 7412 8b45d0 2403 3c01 }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   2403                 | and                 al, 3
            //   3c01                 | cmp                 al, 1

        $sequence_9 = { 895e64 e9???????? 53 57 }
            // n = 4, score = 200
            //   895e64               | mov                 dword ptr [esi + 0x64], ebx
            //   e9????????           |                     
            //   53                   | push                ebx
            //   57                   | push                edi

        $sequence_10 = { 8b6c2468 55 6a02 33db 33ff ff15???????? 8bf0 }
            // n = 7, score = 200
            //   8b6c2468             | mov                 ebp, dword ptr [esp + 0x68]
            //   55                   | push                ebp
            //   6a02                 | push                2
            //   33db                 | xor                 ebx, ebx
            //   33ff                 | xor                 edi, edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_11 = { 7443 8b45d4 83ff10 7303 }
            // n = 4, score = 200
            //   7443                 | je                  0x45
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   83ff10               | cmp                 edi, 0x10
            //   7303                 | jae                 5

        $sequence_12 = { 005311 40 005d11 40 006711 }
            // n = 5, score = 200
            //   005311               | add                 byte ptr [ebx + 0x11], dl
            //   40                   | inc                 eax
            //   005d11               | add                 byte ptr [ebp + 0x11], bl
            //   40                   | inc                 eax
            //   006711               | add                 byte ptr [edi + 0x11], ah

        $sequence_13 = { 8965f0 85c9 7504 33ff eb16 }
            // n = 5, score = 200
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   85c9                 | test                ecx, ecx
            //   7504                 | jne                 6
            //   33ff                 | xor                 edi, edi
            //   eb16                 | jmp                 0x18

        $sequence_14 = { 895e64 ff15???????? 8b442414 50 }
            // n = 4, score = 200
            //   895e64               | mov                 dword ptr [esi + 0x64], ebx
            //   ff15????????         |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax

        $sequence_15 = { 7412 8b45a4 83c01f 3945b0 }
            // n = 4, score = 200
            //   7412                 | je                  0x14
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   83c01f               | add                 eax, 0x1f
            //   3945b0               | cmp                 dword ptr [ebp - 0x50], eax

    condition:
        7 of them and filesize < 819200
}