rule win_prestige_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.prestige."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prestige"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83e920 e9???????? 83e920 e9???????? 83e904 e9???????? 83e93c }
            // n = 7, score = 100
            //   83e920               | sub                 ecx, 0x20
            //   e9????????           |                     
            //   83e920               | sub                 ecx, 0x20
            //   e9????????           |                     
            //   83e904               | sub                 ecx, 4
            //   e9????????           |                     
            //   83e93c               | sub                 ecx, 0x3c

        $sequence_1 = { 0f86e4010000 85c0 7430 6bc809 8945f4 8bc3 2bc6 }
            // n = 7, score = 100
            //   0f86e4010000         | jbe                 0x1ea
            //   85c0                 | test                eax, eax
            //   7430                 | je                  0x32
            //   6bc809               | imul                ecx, eax, 9
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8bc3                 | mov                 eax, ebx
            //   2bc6                 | sub                 eax, esi

        $sequence_2 = { e8???????? 51 68???????? 8d8dc0fcffff c645fc9f e8???????? 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d8dc0fcffff         | lea                 ecx, [ebp - 0x340]
            //   c645fc9f             | mov                 byte ptr [ebp - 4], 0x9f
            //   e8????????           |                     
            //   51                   | push                ecx

        $sequence_3 = { e8???????? 51 68???????? 8d8d28fbffff c645fc8e e8???????? 51 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d8d28fbffff         | lea                 ecx, [ebp - 0x4d8]
            //   c645fc8e             | mov                 byte ptr [ebp - 4], 0x8e
            //   e8????????           |                     
            //   51                   | push                ecx

        $sequence_4 = { 0f9fc1 03ca 8b55ec 2bc2 3bc1 7ce0 6a0d }
            // n = 7, score = 100
            //   0f9fc1               | setg                cl
            //   03ca                 | add                 ecx, edx
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   2bc2                 | sub                 eax, edx
            //   3bc1                 | cmp                 eax, ecx
            //   7ce0                 | jl                  0xffffffe2
            //   6a0d                 | push                0xd

        $sequence_5 = { 68???????? 8d8d08faffff c645fc82 e8???????? 51 68???????? 8d8d20faffff }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d8d08faffff         | lea                 ecx, [ebp - 0x5f8]
            //   c645fc82             | mov                 byte ptr [ebp - 4], 0x82
            //   e8????????           |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d8d20faffff         | lea                 ecx, [ebp - 0x5e0]

        $sequence_6 = { 8d55fc 6a0a ff7310 8d4de4 e8???????? 59 59 }
            // n = 7, score = 100
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   6a0a                 | push                0xa
            //   ff7310               | push                dword ptr [ebx + 0x10]
            //   8d4de4               | lea                 ecx, [ebp - 0x1c]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx

        $sequence_7 = { 59 59 0f45fb eb6f 8845d8 8b01 8b501c }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   0f45fb               | cmovne              edi, ebx
            //   eb6f                 | jmp                 0x71
            //   8845d8               | mov                 byte ptr [ebp - 0x28], al
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b501c               | mov                 edx, dword ptr [eax + 0x1c]

        $sequence_8 = { e8???????? 8bc6 c1e002 50 8b8598f8ffff 0fb70485bc534700 8d0485b84a4700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   8b8598f8ffff         | mov                 eax, dword ptr [ebp - 0x768]
            //   0fb70485bc534700     | movzx               eax, word ptr [eax*4 + 0x4753bc]
            //   8d0485b84a4700       | lea                 eax, [eax*4 + 0x474ab8]

        $sequence_9 = { 8bf0 8b4b2c 8b5330 3bce 7426 85d2 740f }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8b4b2c               | mov                 ecx, dword ptr [ebx + 0x2c]
            //   8b5330               | mov                 edx, dword ptr [ebx + 0x30]
            //   3bce                 | cmp                 ecx, esi
            //   7426                 | je                  0x28
            //   85d2                 | test                edx, edx
            //   740f                 | je                  0x11

    condition:
        7 of them and filesize < 1518592
}