rule win_prikormka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.prikormka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prikormka"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d0446 50 e8???????? 83c40c 6a00 56 }
            // n = 6, score = 1600
            //   8d0446               | lea                 eax, [esi + eax*2]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_1 = { 6a00 56 ffd3 8b2d???????? 85c0 7405 }
            // n = 6, score = 1400
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   8b2d????????         |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7

        $sequence_2 = { 8d1446 52 e8???????? 83c40c }
            // n = 4, score = 1400
            //   8d1446               | lea                 edx, [esi + eax*2]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 6800020000 ff15???????? 68???????? ffd7 03c0 50 68???????? }
            // n = 7, score = 1400
            //   6800020000           | push                0x200
            //   ff15????????         |                     
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_4 = { 51 e8???????? 83c40c 68???????? ffd7 }
            // n = 5, score = 1400
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   ffd7                 | call                edi

        $sequence_5 = { 85f6 7420 68???????? ffd7 }
            // n = 4, score = 1400
            //   85f6                 | test                esi, esi
            //   7420                 | je                  0x22
            //   68????????           |                     
            //   ffd7                 | call                edi

        $sequence_6 = { 6a00 56 ffd3 85c0 7405 6a02 56 }
            // n = 7, score = 1400
            //   6a00                 | push                0
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   6a02                 | push                2
            //   56                   | push                esi

        $sequence_7 = { 740e 68???????? 50 ff15???????? ffd0 }
            // n = 5, score = 1400
            //   740e                 | je                  0x10
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ffd0                 | call                eax

        $sequence_8 = { 7408 41 42 3bce }
            // n = 4, score = 1000
            //   7408                 | je                  0xa
            //   41                   | inc                 ecx
            //   42                   | inc                 edx
            //   3bce                 | cmp                 ecx, esi

        $sequence_9 = { 83c40c 8d442404 50 ff15???????? 5e 85c0 }
            // n = 6, score = 1000
            //   83c40c               | add                 esp, 0xc
            //   8d442404             | lea                 eax, [esp + 4]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax

        $sequence_10 = { 59 c3 50 ff15???????? b801000000 }
            // n = 5, score = 1000
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1

        $sequence_11 = { 6a00 6a00 ff15???????? 85c0 7502 59 c3 }
            // n = 7, score = 1000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   59                   | pop                 ecx
            //   c3                   | ret                 

        $sequence_12 = { 0fb7c0 6683f805 7d09 b801000000 }
            // n = 4, score = 900
            //   0fb7c0               | movzx               eax, ax
            //   6683f805             | cmp                 ax, 5
            //   7d09                 | jge                 0xb
            //   b801000000           | mov                 eax, 1

        $sequence_13 = { c3 57 6a00 6a00 6a00 6a02 }
            // n = 6, score = 900
            //   c3                   | ret                 
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a02                 | push                2

        $sequence_14 = { 68???????? ff15???????? 0fb7c0 6683f805 }
            // n = 4, score = 900
            //   68????????           |                     
            //   ff15????????         |                     
            //   0fb7c0               | movzx               eax, ax
            //   6683f805             | cmp                 ax, 5

        $sequence_15 = { ff15???????? ffd0 c705????????01000000 c705????????01000000 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   ffd0                 | call                eax
            //   c705????????01000000     |     
            //   c705????????01000000     |     

        $sequence_16 = { 5e 85c0 7422 68???????? 50 }
            // n = 5, score = 900
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7422                 | je                  0x24
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_17 = { 5e 85c0 7414 c705????????01000000 }
            // n = 4, score = 700
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   c705????????01000000     |     

        $sequence_18 = { 33f6 e8???????? e8???????? e8???????? e8???????? e8???????? e8???????? }
            // n = 7, score = 700
            //   33f6                 | xor                 esi, esi
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_19 = { 6685d2 75f5 2bce 8d1400 52 d1f9 }
            // n = 6, score = 600
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7
            //   2bce                 | sub                 ecx, esi
            //   8d1400               | lea                 edx, [eax + eax]
            //   52                   | push                edx
            //   d1f9                 | sar                 ecx, 1

        $sequence_20 = { 8bf0 ff15???????? 3db7000000 751f }
            // n = 4, score = 600
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   751f                 | jne                 0x21

        $sequence_21 = { 50 e8???????? 8b2d???????? 83c40c 6a00 }
            // n = 5, score = 600
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b2d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0

        $sequence_22 = { 3db7000000 751f 56 ff15???????? 33c0 }
            // n = 5, score = 600
            //   3db7000000           | cmp                 eax, 0xb7
            //   751f                 | jne                 0x21
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_23 = { 668b08 83c002 6685c9 75f5 8b0d???????? 2bc2 8b15???????? }
            // n = 7, score = 600
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8b0d????????         |                     
            //   2bc2                 | sub                 eax, edx
            //   8b15????????         |                     

        $sequence_24 = { d1f8 8d7102 8da42400000000 668b11 83c102 6685d2 }
            // n = 6, score = 500
            //   d1f8                 | sar                 eax, 1
            //   8d7102               | lea                 esi, [ecx + 2]
            //   8da42400000000       | lea                 esp, [esp]
            //   668b11               | mov                 dx, word ptr [ecx]
            //   83c102               | add                 ecx, 2
            //   6685d2               | test                dx, dx

        $sequence_25 = { e8???????? 8b35???????? 83c40c 68???????? ffd6 03c0 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   03c0                 | add                 eax, eax

        $sequence_26 = { 50 e8???????? b8???????? 83c40c 8d5002 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   b8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d5002               | lea                 edx, [eax + 2]

        $sequence_27 = { 6685c9 75f5 8d0c12 2bc6 51 d1f8 8d544408 }
            // n = 7, score = 500
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8d0c12               | lea                 ecx, [edx + edx]
            //   2bc6                 | sub                 eax, esi
            //   51                   | push                ecx
            //   d1f8                 | sar                 eax, 1
            //   8d544408             | lea                 edx, [esp + eax*2 + 8]

        $sequence_28 = { 75f5 2bc6 8d0c12 51 d1f8 }
            // n = 5, score = 500
            //   75f5                 | jne                 0xfffffff7
            //   2bc6                 | sub                 eax, esi
            //   8d0c12               | lea                 ecx, [edx + edx]
            //   51                   | push                ecx
            //   d1f8                 | sar                 eax, 1

        $sequence_29 = { 85c0 7409 6a02 68???????? }
            // n = 4, score = 400
            //   85c0                 | test                eax, eax
            //   7409                 | je                  0xb
            //   6a02                 | push                2
            //   68????????           |                     

        $sequence_30 = { 52 0fb754241c 50 0fb7442422 }
            // n = 4, score = 400
            //   52                   | push                edx
            //   0fb754241c           | movzx               edx, word ptr [esp + 0x1c]
            //   50                   | push                eax
            //   0fb7442422           | movzx               eax, word ptr [esp + 0x22]

        $sequence_31 = { e8???????? 83c40c eb0d 6a00 6800020000 ff15???????? }
            // n = 6, score = 300
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   eb0d                 | jmp                 0xf
            //   6a00                 | push                0
            //   6800020000           | push                0x200
            //   ff15????????         |                     

        $sequence_32 = { 68???????? 33ff 57 57 ff15???????? 8bf0 }
            // n = 6, score = 300
            //   68????????           |                     
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_33 = { 68???????? ffd6 50 68???????? 57 ffd6 03c7 }
            // n = 7, score = 300
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   03c7                 | add                 eax, edi

        $sequence_34 = { 75f5 2bc2 b9???????? d1f8 8d7102 668b11 }
            // n = 6, score = 300
            //   75f5                 | jne                 0xfffffff7
            //   2bc2                 | sub                 eax, edx
            //   b9????????           |                     
            //   d1f8                 | sar                 eax, 1
            //   8d7102               | lea                 esi, [ecx + 2]
            //   668b11               | mov                 dx, word ptr [ecx]

        $sequence_35 = { 83c002 6685c9 75f5 2bc6 03d2 52 }
            // n = 6, score = 300
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bc6                 | sub                 eax, esi
            //   03d2                 | add                 edx, edx
            //   52                   | push                edx

        $sequence_36 = { 6685d2 75f5 8d1400 2bce 52 d1f9 }
            // n = 6, score = 300
            //   6685d2               | test                dx, dx
            //   75f5                 | jne                 0xfffffff7
            //   8d1400               | lea                 edx, [eax + eax]
            //   2bce                 | sub                 ecx, esi
            //   52                   | push                edx
            //   d1f9                 | sar                 ecx, 1

        $sequence_37 = { d1f8 8bd0 b8???????? 8d7002 }
            // n = 4, score = 300
            //   d1f8                 | sar                 eax, 1
            //   8bd0                 | mov                 edx, eax
            //   b8????????           |                     
            //   8d7002               | lea                 esi, [eax + 2]

        $sequence_38 = { b8???????? 8d7002 8da42400000000 668b08 83c002 }
            // n = 5, score = 300
            //   b8????????           |                     
            //   8d7002               | lea                 esi, [eax + 2]
            //   8da42400000000       | lea                 esp, [esp]
            //   668b08               | mov                 cx, word ptr [eax]
            //   83c002               | add                 eax, 2

        $sequence_39 = { 8b1d???????? 83c40c 6a00 68???????? }
            // n = 4, score = 200
            //   8b1d????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_40 = { 50 e8???????? b9???????? 83c40c 8d5102 668b01 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   b9????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d5102               | lea                 edx, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]

        $sequence_41 = { c20400 6a0c b8???????? e8???????? 33c0 8945ec }
            // n = 6, score = 100
            //   c20400               | ret                 4
            //   6a0c                 | push                0xc
            //   b8????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_42 = { 6a00 8d45f8 50 8d34fd0cde0110 ff36 e8???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d34fd0cde0110       | lea                 esi, [edi*8 + 0x1001de0c]
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_43 = { 50 43 6a02 43 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   43                   | inc                 ebx
            //   6a02                 | push                2
            //   43                   | inc                 ebx

        $sequence_44 = { 8d4514 50 e8???????? 53 8d4d00 }
            // n = 5, score = 100
            //   8d4514               | lea                 eax, [ebp + 0x14]
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8d4d00               | lea                 ecx, [ebp]

        $sequence_45 = { 3bfb 7d12 8b4de4 53 }
            // n = 4, score = 100
            //   3bfb                 | cmp                 edi, ebx
            //   7d12                 | jge                 0x14
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 401408
}