rule win_prilex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.prilex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prilex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4ddc ff15???????? 8d4dcc ff15???????? 8d55c4 52 6a00 }
            // n = 7, score = 400
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   ff15????????         |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   ff15????????         |                     
            //   8d55c4               | lea                 edx, [ebp - 0x3c]
            //   52                   | push                edx
            //   6a00                 | push                0

        $sequence_1 = { 8d4db0 50 51 8975b0 e8???????? 8b55e8 }
            // n = 6, score = 400
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8975b0               | mov                 dword ptr [ebp - 0x50], esi
            //   e8????????           |                     
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]

        $sequence_2 = { c785d4feffff01000000 8b45c4 50 6a01 ff15???????? }
            // n = 5, score = 400
            //   c785d4feffff01000000     | mov    dword ptr [ebp - 0x12c], 1
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff15????????         |                     

        $sequence_3 = { 8b550c 3b32 0f84d4000000 3bf7 0f84cc000000 8d55b8 }
            // n = 6, score = 400
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   3b32                 | cmp                 esi, dword ptr [edx]
            //   0f84d4000000         | je                  0xda
            //   3bf7                 | cmp                 esi, edi
            //   0f84cc000000         | je                  0xd2
            //   8d55b8               | lea                 edx, [ebp - 0x48]

        $sequence_4 = { ff15???????? 50 8b45e0 8d4ddc 50 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   50                   | push                eax

        $sequence_5 = { 8bf0 ff15???????? 8d45c8 8d4dcc 50 51 }
            // n = 6, score = 400
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   50                   | push                eax
            //   51                   | push                ecx

        $sequence_6 = { 33c0 833a00 0f95c0 0bc8 85c9 7538 c745fc03000000 }
            // n = 7, score = 400
            //   33c0                 | xor                 eax, eax
            //   833a00               | cmp                 dword ptr [edx], 0
            //   0f95c0               | setne               al
            //   0bc8                 | or                  ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7538                 | jne                 0x3a
            //   c745fc03000000       | mov                 dword ptr [ebp - 4], 3

        $sequence_7 = { 51 e8???????? 8945d0 c745fc04000000 66c785f8feffff0000 8d95f8feffff }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   66c785f8feffff0000     | mov    word ptr [ebp - 0x108], 0
            //   8d95f8feffff         | lea                 edx, [ebp - 0x108]

        $sequence_8 = { 8d8dacfdffff 68???????? 52 898d54fdffff c7854cfdffff08400000 }
            // n = 5, score = 400
            //   8d8dacfdffff         | lea                 ecx, [ebp - 0x254]
            //   68????????           |                     
            //   52                   | push                edx
            //   898d54fdffff         | mov                 dword ptr [ebp - 0x2ac], ecx
            //   c7854cfdffff08400000     | mov    dword ptr [ebp - 0x2b4], 0x4008

        $sequence_9 = { 8b542428 33c0 89442414 53 8944241c 33c9 }
            // n = 6, score = 400
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   33c0                 | xor                 eax, eax
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   53                   | push                ebx
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   33c9                 | xor                 ecx, ecx

    condition:
        7 of them and filesize < 450560
}