rule win_privateloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.privateloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.privateloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bec 83ec1c 894df8 8b45f8 8b4810 894df4 }
            // n = 6, score = 600
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_1 = { 8945f4 8b4dfc 83791408 7209 }
            // n = 4, score = 600
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83791408             | cmp                 dword ptr [ecx + 0x14], 8
            //   7209                 | jb                  0xb

        $sequence_2 = { 8b55e4 8a45ff 88040a 8b45f8 }
            // n = 4, score = 600
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_3 = { 8b4d08 3b4814 776d 8b55f8 8955f4 8b45f4 8945ec }
            // n = 7, score = 600
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   3b4814               | cmp                 ecx, dword ptr [eax + 0x14]
            //   776d                 | ja                  0x6f
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_4 = { 8b45d8 8b4ddc 8b55d0 8b75d4 }
            // n = 4, score = 600
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b55d0               | mov                 edx, dword ptr [ebp - 0x30]
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]

        $sequence_5 = { 8b4508 8945e4 8b4de8 034de4 8a55ff }
            // n = 5, score = 600
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   034de4               | add                 ecx, dword ptr [ebp - 0x1c]
            //   8a55ff               | mov                 dl, byte ptr [ebp - 1]

        $sequence_6 = { 8945c8 8955cc 8b45c8 8b55cc 5e }
            // n = 5, score = 600
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   5e                   | pop                 esi

        $sequence_7 = { 8b55f8 8b45f4 3b4214 736c }
            // n = 4, score = 600
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   3b4214               | cmp                 eax, dword ptr [edx + 0x14]
            //   736c                 | jae                 0x6e

        $sequence_8 = { e8???????? 33d2 b93f000000 f7f1 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   b93f000000           | mov                 ecx, 0x3f
            //   f7f1                 | div                 ecx

        $sequence_9 = { 8b4590 8b4d94 8b5588 8b758c }
            // n = 4, score = 400
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   8b4d94               | mov                 ecx, dword ptr [ebp - 0x6c]
            //   8b5588               | mov                 edx, dword ptr [ebp - 0x78]
            //   8b758c               | mov                 esi, dword ptr [ebp - 0x74]

        $sequence_10 = { a3???????? 33c0 5e c3 3b0d???????? }
            // n = 5, score = 400
            //   a3????????           |                     
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   3b0d????????         |                     

        $sequence_11 = { e8???????? 83c610 83c002 83ef08 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   83c610               | add                 esi, 0x10
            //   83c002               | add                 eax, 2
            //   83ef08               | sub                 edi, 8

        $sequence_12 = { 81ec68010000 a1???????? 33c5 8945fc 56 57 }
            // n = 6, score = 400
            //   81ec68010000         | sub                 esp, 0x168
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_13 = { 83c201 8955e0 83d600 8975e4 }
            // n = 4, score = 300
            //   83c201               | add                 edx, 1
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx
            //   83d600               | adc                 esi, 0
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_14 = { 8b4de0 8b45e4 50 51 52 56 e8???????? }
            // n = 7, score = 300
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_15 = { 6a04 8d4310 50 6a06 }
            // n = 4, score = 300
            //   6a04                 | push                4
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   50                   | push                eax
            //   6a06                 | push                6

        $sequence_16 = { 0bc8 56 57 7529 }
            // n = 4, score = 300
            //   0bc8                 | or                  ecx, eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   7529                 | jne                 0x2b

        $sequence_17 = { 8b8578ffffff 8b8d7cffffff 8b9570ffffff 8bb574ffffff }
            // n = 4, score = 300
            //   8b8578ffffff         | mov                 eax, dword ptr [ebp - 0x88]
            //   8b8d7cffffff         | mov                 ecx, dword ptr [ebp - 0x84]
            //   8b9570ffffff         | mov                 edx, dword ptr [ebp - 0x90]
            //   8bb574ffffff         | mov                 esi, dword ptr [ebp - 0x8c]

        $sequence_18 = { 03d0 8b4d9c 13f1 83c201 }
            // n = 4, score = 300
            //   03d0                 | add                 edx, eax
            //   8b4d9c               | mov                 ecx, dword ptr [ebp - 0x64]
            //   13f1                 | adc                 esi, ecx
            //   83c201               | add                 edx, 1

    condition:
        7 of them and filesize < 3670016
}