rule win_project_wood_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.project_wood."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.project_wood"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7404 6aff eb05 6830750000 53 8d45e8 57 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   6aff                 | push                -1
            //   eb05                 | jmp                 7
            //   6830750000           | push                0x7530
            //   53                   | push                ebx
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   57                   | push                edi

        $sequence_1 = { 57 50 ff7508 ff15???????? 85c0 7426 ff37 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7426                 | je                  0x28
            //   ff37                 | push                dword ptr [edi]

        $sequence_2 = { ffd5 68???????? e8???????? 59 5e 5d 5b }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx

        $sequence_3 = { 7422 8d4df8 b801000080 51 6819000200 57 68???????? }
            // n = 7, score = 100
            //   7422                 | je                  0x24
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   b801000080           | mov                 eax, 0x80000001
            //   51                   | push                ecx
            //   6819000200           | push                0x20019
            //   57                   | push                edi
            //   68????????           |                     

        $sequence_4 = { ff7508 e8???????? 83c41c 84c0 0f84abfeffff 8d8550f7ffff }
            // n = 6, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   84c0                 | test                al, al
            //   0f84abfeffff         | je                  0xfffffeb1
            //   8d8550f7ffff         | lea                 eax, [ebp - 0x8b0]

        $sequence_5 = { 0f8426010000 8d45d8 50 8d85acfeffff 50 ff15???????? 8d45e4 }
            // n = 7, score = 100
            //   0f8426010000         | je                  0x12c
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   50                   | push                eax
            //   8d85acfeffff         | lea                 eax, [ebp - 0x154]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_6 = { 41 83f902 72e3 a3???????? eb10 c705????????01000000 891d???????? }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   83f902               | cmp                 ecx, 2
            //   72e3                 | jb                  0xffffffe5
            //   a3????????           |                     
            //   eb10                 | jmp                 0x12
            //   c705????????01000000     |     
            //   891d????????         |                     

        $sequence_7 = { ab ab 66ab aa 8d45f0 c745f050000000 50 }
            // n = 7, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   c745f050000000       | mov                 dword ptr [ebp - 0x10], 0x50
            //   50                   | push                eax

        $sequence_8 = { 7222 8d85a4f7ffff 6a04 50 8d450c 50 e8???????? }
            // n = 7, score = 100
            //   7222                 | jb                  0x24
            //   8d85a4f7ffff         | lea                 eax, [ebp - 0x85c]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 0f84e3feffff 57 8d45f8 ff7518 ff7514 50 8d8558f7ffff }
            // n = 7, score = 100
            //   0f84e3feffff         | je                  0xfffffee9
            //   57                   | push                edi
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   ff7518               | push                dword ptr [ebp + 0x18]
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   50                   | push                eax
            //   8d8558f7ffff         | lea                 eax, [ebp - 0x8a8]

    condition:
        7 of them and filesize < 31137792
}