rule win_prometei_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.prometei."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.prometei"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 011d???????? 03c8 8b5de4 a1???????? }
            // n = 4, score = 100
            //   011d????????         |                     
            //   03c8                 | add                 ecx, eax
            //   8b5de4               | mov                 ebx, dword ptr [ebp - 0x1c]
            //   a1????????           |                     

        $sequence_1 = { 5b 8d7db0 8907 8bc7 bf1f000000 897004 894808 }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   8d7db0               | lea                 edi, [ebp - 0x50]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8bc7                 | mov                 eax, edi
            //   bf1f000000           | mov                 edi, 0x1f
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   894808               | mov                 dword ptr [eax + 8], ecx

        $sequence_2 = { 33c0 85ff 742c 8b75d8 03f2 0fbe5405b8 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   85ff                 | test                edi, edi
            //   742c                 | je                  0x2e
            //   8b75d8               | mov                 esi, dword ptr [ebp - 0x28]
            //   03f2                 | add                 esi, edx
            //   0fbe5405b8           | movsx               edx, byte ptr [ebp + eax - 0x48]

        $sequence_3 = { 014368 81434400020000 c7434000000000 83534800 }
            // n = 4, score = 100
            //   014368               | add                 dword ptr [ebx + 0x68], eax
            //   81434400020000       | add                 dword ptr [ebx + 0x44], 0x200
            //   c7434000000000       | mov                 dword ptr [ebx + 0x40], 0
            //   83534800             | adc                 dword ptr [ebx + 0x48], 0

        $sequence_4 = { 014358 8b45f0 01435c 8b45fc }
            // n = 4, score = 100
            //   014358               | add                 dword ptr [ebx + 0x58], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   01435c               | add                 dword ptr [ebx + 0x5c], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_5 = { ff15???????? 0fbe05???????? 56 8945fc ff15???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   0fbe05????????       |                     
            //   56                   | push                esi
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     

        $sequence_6 = { b801000000 f745c000020000 8bd1 0f44f8 }
            // n = 4, score = 100
            //   b801000000           | mov                 eax, 1
            //   f745c000020000       | test                dword ptr [ebp - 0x40], 0x200
            //   8bd1                 | mov                 edx, ecx
            //   0f44f8               | cmove               edi, eax

        $sequence_7 = { 833d????????00 0f85cc000000 6a00 6880000000 6a03 6a00 6a00 }
            // n = 7, score = 100
            //   833d????????00       |                     
            //   0f85cc000000         | jne                 0xd2
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_8 = { 10d0 00bb2d784334 2cbb 8d3b 61 }
            // n = 5, score = 100
            //   10d0                 | adc                 al, dl
            //   00bb2d784334         | add                 byte ptr [ebx + 0x3443782d], bh
            //   2cbb                 | sub                 al, 0xbb
            //   8d3b                 | lea                 edi, [ebx]
            //   61                   | popal               

        $sequence_9 = { f5 b56b 55 48 2d63d3c0b9 25809d1976 0482 }
            // n = 7, score = 100
            //   f5                   | cmc                 
            //   b56b                 | mov                 ch, 0x6b
            //   55                   | push                ebp
            //   48                   | dec                 eax
            //   2d63d3c0b9           | sub                 eax, 0xb9c0d363
            //   25809d1976           | and                 eax, 0x76199d80
            //   0482                 | add                 al, 0x82

        $sequence_10 = { 013d???????? 8b04b5c8054400 0500080000 3bc8 }
            // n = 4, score = 100
            //   013d????????         |                     
            //   8b04b5c8054400       | mov                 eax, dword ptr [esi*4 + 0x4405c8]
            //   0500080000           | add                 eax, 0x800
            //   3bc8                 | cmp                 ecx, eax

        $sequence_11 = { 01435c 8b45fc 014360 8b45f4 }
            // n = 4, score = 100
            //   01435c               | add                 dword ptr [ebx + 0x5c], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   014360               | add                 dword ptr [ebx + 0x60], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_12 = { e8???????? 44 b46b d6 1e }
            // n = 5, score = 100
            //   e8????????           |                     
            //   44                   | inc                 esp
            //   b46b                 | mov                 ah, 0x6b
            //   d6                   | salc                
            //   1e                   | push                ds

        $sequence_13 = { 014364 8b45e4 014368 5b }
            // n = 4, score = 100
            //   014364               | add                 dword ptr [ebx + 0x64], eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   014368               | add                 dword ptr [ebx + 0x68], eax
            //   5b                   | pop                 ebx

        $sequence_14 = { 014360 8b45f4 014364 8b45e4 }
            // n = 4, score = 100
            //   014360               | add                 dword ptr [ebx + 0x60], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   014364               | add                 dword ptr [ebx + 0x64], eax
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_15 = { 014354 8b45e8 014358 8b45f0 }
            // n = 4, score = 100
            //   014354               | add                 dword ptr [ebx + 0x54], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   014358               | add                 dword ptr [ebx + 0x58], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

    condition:
        7 of them and filesize < 51014656
}