rule win_proteus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-05-30"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.4.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.proteus"
        malpedia_rule_date = "20200529"
        malpedia_hash = "92c362319514e5a6da26204961446caa3a8b32a8"
        malpedia_version = "20200529"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e74a 6d b0b2 a1???????? 71fb }
            // n = 5, score = 100
            //   e74a                 | out                 0x4a, eax
            //   6d                   | insd                dword ptr es:[edi], dx
            //   b0b2                 | mov                 al, 0xb2
            //   a1????????           |                     
            //   71fb                 | jno                 0xfffffffd

        $sequence_1 = { b388 d957ef 1d9edbe60e e8???????? de9fab02e7c2 }
            // n = 5, score = 100
            //   b388                 | mov                 bl, 0x88
            //   d957ef               | fst                 dword ptr [edi - 0x11]
            //   1d9edbe60e           | sbb                 eax, 0xee6db9e
            //   e8????????           |                     
            //   de9fab02e7c2         | ficomp              word ptr [edi - 0x3d18fd55]

        $sequence_2 = { c9 3a98b3bc15b5 7eb8 68aa362158 }
            // n = 4, score = 100
            //   c9                   | leave               
            //   3a98b3bc15b5         | cmp                 bl, byte ptr [eax - 0x4aea434d]
            //   7eb8                 | jle                 0xffffffba
            //   68aa362158           | push                0x582136aa

        $sequence_3 = { 19c4 3e31de fd 1576ea9453 }
            // n = 4, score = 100
            //   19c4                 | sbb                 esp, eax
            //   3e31de               | xor                 esi, ebx
            //   fd                   | std                 
            //   1576ea9453           | adc                 eax, 0x5394ea76

        $sequence_4 = { 6d b0b2 a1???????? 71fb 70d9 2d6c0f17e9 4f }
            // n = 7, score = 100
            //   6d                   | insd                dword ptr es:[edi], dx
            //   b0b2                 | mov                 al, 0xb2
            //   a1????????           |                     
            //   71fb                 | jno                 0xfffffffd
            //   70d9                 | jo                  0xffffffdb
            //   2d6c0f17e9           | sub                 eax, 0xe9170f6c
            //   4f                   | dec                 edi

        $sequence_5 = { a1???????? 71fb 70d9 2d6c0f17e9 4f 19c4 3e31de }
            // n = 7, score = 100
            //   a1????????           |                     
            //   71fb                 | jno                 0xfffffffd
            //   70d9                 | jo                  0xffffffdb
            //   2d6c0f17e9           | sub                 eax, 0xe9170f6c
            //   4f                   | dec                 edi
            //   19c4                 | sbb                 esp, eax
            //   3e31de               | xor                 esi, ebx

        $sequence_6 = { a2???????? 1cff 5c 9f 12ff }
            // n = 5, score = 100
            //   a2????????           |                     
            //   1cff                 | sbb                 al, 0xff
            //   5c                   | pop                 esp
            //   9f                   | lahf                
            //   12ff                 | adc                 bh, bh

        $sequence_7 = { 1bff 61 a2???????? 1cff 5c 9f 12ff }
            // n = 7, score = 100
            //   1bff                 | sbb                 edi, edi
            //   61                   | popal               
            //   a2????????           |                     
            //   1cff                 | sbb                 al, 0xff
            //   5c                   | pop                 esp
            //   9f                   | lahf                
            //   12ff                 | adc                 bh, bh

        $sequence_8 = { 95 b388 d957ef 1d9edbe60e e8???????? }
            // n = 5, score = 100
            //   95                   | xchg                eax, ebp
            //   b388                 | mov                 bl, 0x88
            //   d957ef               | fst                 dword ptr [edi - 0x11]
            //   1d9edbe60e           | sbb                 eax, 0xee6db9e
            //   e8????????           |                     

        $sequence_9 = { 71fb 70d9 2d6c0f17e9 4f }
            // n = 4, score = 100
            //   71fb                 | jno                 0xfffffffd
            //   70d9                 | jo                  0xffffffdb
            //   2d6c0f17e9           | sub                 eax, 0xe9170f6c
            //   4f                   | dec                 edi

    condition:
        7 of them and filesize < 5898240
}