rule win_pslogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pslogger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pslogger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bc8 e8???????? 4863f0 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8bc8                 | dec                 eax
            //   e8????????           |                     
            //   4863f0               | mov                 ecx, ebp

        $sequence_1 = { 4885c9 7406 ff15???????? 4883c318 }
            // n = 4, score = 300
            //   4885c9               | mov                 ecx, 0x10
            //   7406                 | test                ax, ax
            //   ff15????????         |                     
            //   4883c318             | jns                 0x12

        $sequence_2 = { 8d4601 4863e8 488bcd e8???????? }
            // n = 4, score = 300
            //   8d4601               | lea                 eax, [esi + 1]
            //   4863e8               | dec                 eax
            //   488bcd               | arpl                ax, bp
            //   e8????????           |                     

        $sequence_3 = { 483bc8 740e 4885c9 7406 }
            // n = 4, score = 300
            //   483bc8               | test                ecx, ecx
            //   740e                 | je                  0x15
            //   4885c9               | dec                 eax
            //   7406                 | add                 ebx, 0x18

        $sequence_4 = { ff15???????? b801000000 488b8c2488000000 4833cc e8???????? }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   b801000000           | mov                 ecx, eax
            //   488b8c2488000000     | dec                 eax
            //   4833cc               | arpl                ax, si
            //   e8????????           |                     

        $sequence_5 = { 498bcc e8???????? 33d2 41b8b80b0000 498bcc }
            // n = 5, score = 300
            //   498bcc               | je                  0x15
            //   e8????????           |                     
            //   33d2                 | dec                 eax
            //   41b8b80b0000         | test                ecx, ecx
            //   498bcc               | je                  0x12

        $sequence_6 = { c3 488b0d???????? 33d2 ff15???????? 488b0d???????? 33d2 ff15???????? }
            // n = 7, score = 300
            //   c3                   | mov                 ecx, 0x14
            //   488b0d????????       |                     
            //   33d2                 | test                ax, ax
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   33d2                 | dec                 eax
            //   ff15????????         |                     

        $sequence_7 = { b910000000 ff15???????? 6685c0 7910 b914000000 ff15???????? 6685c0 }
            // n = 7, score = 300
            //   b910000000           | mov                 eax, 1
            //   ff15????????         |                     
            //   6685c0               | dec                 eax
            //   7910                 | mov                 ecx, dword ptr [esp + 0x88]
            //   b914000000           | dec                 eax
            //   ff15????????         |                     
            //   6685c0               | xor                 ecx, esp

        $sequence_8 = { 895c2414 ff35???????? ffd6 e9???????? 85c9 }
            // n = 5, score = 100
            //   895c2414             | mov                 esi, eax
            //   ff35????????         |                     
            //   ffd6                 | add                 esp, 8
            //   e9????????           |                     
            //   85c9                 | test                esi, esi

        $sequence_9 = { 8bf0 83c408 85f6 0f84e8000000 8bce 8d5101 }
            // n = 6, score = 100
            //   8bf0                 | test                eax, eax
            //   83c408               | dec                 eax
            //   85f6                 | add                 esp, 0x28
            //   0f84e8000000         | ret                 
            //   8bce                 | xor                 edx, edx
            //   8d5101               | mov                 ecx, 0xbb8

        $sequence_10 = { 85c0 7e25 66660f1f840000000000 8894373d1c0000 b801000000 }
            // n = 5, score = 100
            //   85c0                 | pop                 eax
            //   7e25                 | mov                 word ptr [esi], ax
            //   66660f1f840000000000     | mov    eax, dword ptr [ecx*4 + 0x42b188]
            //   8894373d1c0000       | push                0xa
            //   b801000000           | mov                 byte ptr [eax + edi + 0x2a], dl

        $sequence_11 = { 393b 0f45f8 33c9 89bd58fbffff 0f1f4000 }
            // n = 5, score = 100
            //   393b                 | xor                 edx, edx
            //   0f45f8               | inc                 ecx
            //   33c9                 | mov                 eax, 0xbb8
            //   89bd58fbffff         | dec                 eax
            //   0f1f4000             | mov                 ecx, eax

        $sequence_12 = { 6bc830 8b049588b14200 f644082801 7414 8d4508 8945fc 8d45fc }
            // n = 7, score = 100
            //   6bc830               | dec                 esp
            //   8b049588b14200       | mov                 esp, eax
            //   f644082801           | dec                 eax
            //   7414                 | mov                 dword ptr [esp + 8], ebx
            //   8d4508               | push                edi
            //   8945fc               | dec                 eax
            //   8d45fc               | sub                 esp, 0x20

        $sequence_13 = { 68???????? 50 e8???????? 8d842470030000 68???????? 50 e8???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | dec                 eax
            //   e8????????           |                     
            //   8d842470030000       | mov                 ebx, dword ptr [ecx]
            //   68????????           |                     
            //   50                   | dec                 eax
            //   e8????????           |                     

        $sequence_14 = { 85c0 0f8568fcffff 668b8594fbffff 83431810 }
            // n = 4, score = 100
            //   85c0                 | mov                 edi, ecx
            //   0f8568fcffff         | dec                 eax
            //   668b8594fbffff       | cmp                 ebx, dword ptr [ecx + 8]
            //   83431810             | je                  0x4d

        $sequence_15 = { 58 668906 8b048d88b14200 6a0a 8854382a }
            // n = 5, score = 100
            //   58                   | dec                 eax
            //   668906               | mov                 ecx, eax
            //   8b048d88b14200       | mov                 ecx, eax
            //   6a0a                 | dec                 eax
            //   8854382a             | arpl                ax, si

    condition:
        7 of them and filesize < 475136
}