rule win_pteranodon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pteranodon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pteranodon"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f81d 7cf1 eb07 8b0cc584d70210 894de4 85c9 7455 }
            // n = 7, score = 100
            //   83f81d               | cmp                 eax, 0x1d
            //   7cf1                 | jl                  0xfffffff3
            //   eb07                 | jmp                 9
            //   8b0cc584d70210       | mov                 ecx, dword ptr [eax*8 + 0x1002d784]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx
            //   7455                 | je                  0x57

        $sequence_1 = { 8bcb e8???????? 83c41c 8d85a8f6ffff 50 6802020000 ff15???????? }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8d85a8f6ffff         | lea                 eax, [ebp - 0x958]
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   ff15????????         |                     

        $sequence_2 = { 6a00 6a00 56 68???????? ff15???????? 56 e8???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   68????????           |                     
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_3 = { 8b049de0874300 8b4de0 f644082801 7515 }
            // n = 4, score = 100
            //   8b049de0874300       | mov                 eax, dword ptr [ebx*4 + 0x4387e0]
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7515                 | jne                 0x17

        $sequence_4 = { ff5018 8b5dd0 83e800 7409 83e801 }
            // n = 5, score = 100
            //   ff5018               | call                dword ptr [eax + 0x18]
            //   8b5dd0               | mov                 ebx, dword ptr [ebp - 0x30]
            //   83e800               | sub                 eax, 0
            //   7409                 | je                  0xb
            //   83e801               | sub                 eax, 1

        $sequence_5 = { e8???????? 68???????? 8d95a8f8ffff c645fc12 8d8d60f8ffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d95a8f8ffff         | lea                 edx, [ebp - 0x758]
            //   c645fc12             | mov                 byte ptr [ebp - 4], 0x12
            //   8d8d60f8ffff         | lea                 ecx, [ebp - 0x7a0]

        $sequence_6 = { 894df8 8b048de0874300 33c9 41 897df0 }
            // n = 5, score = 100
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b048de0874300       | mov                 eax, dword ptr [ecx*4 + 0x4387e0]
            //   33c9                 | xor                 ecx, ecx
            //   41                   | inc                 ecx
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi

        $sequence_7 = { eb0e 6a06 c74634789f4200 59 c6463c00 5f 894e38 }
            // n = 7, score = 100
            //   eb0e                 | jmp                 0x10
            //   6a06                 | push                6
            //   c74634789f4200       | mov                 dword ptr [esi + 0x34], 0x429f78
            //   59                   | pop                 ecx
            //   c6463c00             | mov                 byte ptr [esi + 0x3c], 0
            //   5f                   | pop                 edi
            //   894e38               | mov                 dword ptr [esi + 0x38], ecx

        $sequence_8 = { c785fcfeffff6f002e00 c78500ffffff72007500 e8???????? 6800010000 8bf8 }
            // n = 5, score = 100
            //   c785fcfeffff6f002e00     | mov    dword ptr [ebp - 0x104], 0x2e006f
            //   c78500ffffff72007500     | mov    dword ptr [ebp - 0x100], 0x750072
            //   e8????????           |                     
            //   6800010000           | push                0x100
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 83c408 83f8ff bbffffffff 0f455d08 eb06 8b4dec }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   83f8ff               | cmp                 eax, -1
            //   bbffffffff           | mov                 ebx, 0xffffffff
            //   0f455d08             | cmovne              ebx, dword ptr [ebp + 8]
            //   eb06                 | jmp                 8
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]

        $sequence_10 = { c685d8f8ffff00 e8???????? 8d85d8f8ffff c645fc22 50 }
            // n = 5, score = 100
            //   c685d8f8ffff00       | mov                 byte ptr [ebp - 0x728], 0
            //   e8????????           |                     
            //   8d85d8f8ffff         | lea                 eax, [ebp - 0x728]
            //   c645fc22             | mov                 byte ptr [ebp - 4], 0x22
            //   50                   | push                eax

        $sequence_11 = { e8???????? 8bc8 83c404 894de8 8b01 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   83c404               | add                 esp, 4
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_12 = { 8b55ec 8d45d8 8b4dd8 83fa10 8b75d4 0f43c1 2bf0 }
            // n = 7, score = 100
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   83fa10               | cmp                 edx, 0x10
            //   8b75d4               | mov                 esi, dword ptr [ebp - 0x2c]
            //   0f43c1               | cmovae              eax, ecx
            //   2bf0                 | sub                 esi, eax

        $sequence_13 = { 663b88e0e60210 740d 83c002 83f814 72ef 33c0 40 }
            // n = 7, score = 100
            //   663b88e0e60210       | cmp                 cx, word ptr [eax + 0x1002e6e0]
            //   740d                 | je                  0xf
            //   83c002               | add                 eax, 2
            //   83f814               | cmp                 eax, 0x14
            //   72ef                 | jb                  0xfffffff1
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_14 = { 6a06 6a01 6a02 8b00 }
            // n = 4, score = 100
            //   6a06                 | push                6
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_15 = { 68???????? 56 ff15???????? 68b0000000 8d853cffffff 6a00 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   68b0000000           | push                0xb0
            //   8d853cffffff         | lea                 eax, [ebp - 0xc4]
            //   6a00                 | push                0
            //   50                   | push                eax

    condition:
        7 of them and filesize < 499712
}