rule win_pulsartea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pulsartea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pulsartea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745bc00000000 418bde 488b0f 488d55c0 e8???????? }
            // n = 5, score = 100
            //   c745bc00000000       | inc                 ebp
            //   418bde               | xor                 eax, eax
            //   488b0f               | inc                 esp
            //   488d55c0             | or                  edi, eax
            //   e8????????           |                     

        $sequence_1 = { 4889542420 488bcb e8???????? 4d8d870c020000 488d15a6500200 }
            // n = 5, score = 100
            //   4889542420           | dec                 eax
            //   488bcb               | lea                 edx, [ebp + 0x30]
            //   e8????????           |                     
            //   4d8d870c020000       | dec                 ecx
            //   488d15a6500200       | mov                 ecx, edi

        $sequence_2 = { 488d41f8 4883f81f 0f8789000000 498bc8 e8???????? 4c896e10 48c746180f000000 }
            // n = 7, score = 100
            //   488d41f8             | jmp                 0x12c0
            //   4883f81f             | dec                 eax
            //   0f8789000000         | mov                 dword ptr [esp + 0x20], 4
            //   498bc8               | dec                 esp
            //   e8????????           |                     
            //   4c896e10             | lea                 ecx, [esp + 0x40]
            //   48c746180f000000     | mov                 edx, 4

        $sequence_3 = { 4c8d4d80 4533c0 8bd0 488d8d20060000 ff15???????? 440fb745a4 4533c9 }
            // n = 7, score = 100
            //   4c8d4d80             | mov                 esi, dword ptr [ebp + 0x40]
            //   4533c0               | dec                 eax
            //   8bd0                 | mov                 edx, dword ptr [esp + 0x68]
            //   488d8d20060000       | dec                 eax
            //   ff15????????         |                     
            //   440fb745a4           | cmp                 edx, 0x10
            //   4533c9               | jb                  0xea

        $sequence_4 = { 418b048e 4133c1 8983a4000000 458842ff 4883ed01 }
            // n = 5, score = 100
            //   418b048e             | mov                 dword ptr [eax - 8], ecx
            //   4133c1               | jmp                 0x32f
            //   8983a4000000         | je                  0x5cf
            //   458842ff             | dec                 eax
            //   4883ed01             | add                 eax, 0x27

        $sequence_5 = { 488bc8 ff15???????? 85c0 0f84be000000 488b4c2440 488d442448 41b92c010000 }
            // n = 7, score = 100
            //   488bc8               | inc                 ecx
            //   ff15????????         |                     
            //   85c0                 | mov                 eax, 0x434
            //   0f84be000000         | dec                 eax
            //   488b4c2440           | lea                 ecx, [ebp + 0x224]
            //   488d442448           | mov                 dword ptr [ebp + 0x220], 0x438
            //   41b92c010000         | dec                 eax

        $sequence_6 = { 48c74424480f000000 4088742430 498b442410 4883f810 0f823b0b0000 4883c0f0 41b804000000 }
            // n = 7, score = 100
            //   48c74424480f000000     | mov    eax, edi
            //   4088742430           | dec                 eax
            //   498b442410           | mov                 eax, edx
            //   4883f810             | dec                 eax
            //   0f823b0b0000         | sub                 eax, ecx
            //   4883c0f0             | dec                 eax
            //   41b804000000         | cmp                 eax, 4

        $sequence_7 = { e8???????? 33db 8bf8 85c0 0f8454020000 4c8d25646e0100 448bf3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33db                 | mov                 dword ptr [esp + 0x60], 0
            //   8bf8                 | dec                 eax
            //   85c0                 | mov                 dword ptr [esp + 0x68], 0xf
            //   0f8454020000         | mov                 byte ptr [esp + 0x50], 0
            //   4c8d25646e0100       | dec                 eax
            //   448bf3               | mov                 eax, dword ptr [ebp + 0x40]

        $sequence_8 = { 4c897f10 488bc7 48837f1810 7203 488b07 c60000 488b4f10 }
            // n = 7, score = 100
            //   4c897f10             | dec                 eax
            //   488bc7               | sub                 esp, 0x820
            //   48837f1810           | dec                 eax
            //   7203                 | xor                 eax, esp
            //   488b07               | dec                 eax
            //   c60000               | mov                 dword ptr [ebp + 0x710], eax
            //   488b4f10             | inc                 esp

        $sequence_9 = { c1e806 83e001 418986380c0000 83ff17 756d 0f57c0 448d4f4d }
            // n = 7, score = 100
            //   c1e806               | mov                 dword ptr [ebp + 0x90], eax
            //   83e001               | dec                 eax
            //   418986380c0000       | lea                 eax, [ebp + 0x328]
            //   83ff17               | dec                 eax
            //   756d                 | mov                 dword ptr [ebp + 0x98], eax
            //   0f57c0               | mov                 eax, dword ptr [ebx + 0x70]
            //   448d4f4d             | dec                 esp

    condition:
        7 of them and filesize < 520192
}