rule win_punkey_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.punkey_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.punkey_pos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff05???????? 8b0d???????? 56 57 6a00 51 ff15???????? }
            // n = 7, score = 200
            //   ff05????????         |                     
            //   8b0d????????         |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_1 = { 56 ffd7 a3???????? 85c0 74ae 5f b801000000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_2 = { 68e7070000 50 ff15???????? ff05???????? }
            // n = 4, score = 200
            //   68e7070000           | push                0x7e7
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff05????????         |                     

        $sequence_3 = { 741d a1???????? 85c0 740e 56 57 68e7070000 }
            // n = 7, score = 200
            //   741d                 | je                  0x1f
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   740e                 | je                  0x10
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e7070000           | push                0x7e7

        $sequence_4 = { ffd7 a3???????? 85c0 74ae 5f b801000000 }
            // n = 6, score = 200
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_5 = { 50 a1???????? 50 ff15???????? 5d c20c00 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   a1????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc

        $sequence_6 = { 85c0 7919 8b4d10 8b550c }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   7919                 | jns                 0x1b
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_7 = { a3???????? 85c0 74ae 5f b801000000 }
            // n = 5, score = 200
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   74ae                 | je                  0xffffffb0
            //   5f                   | pop                 edi
            //   b801000000           | mov                 eax, 1

        $sequence_8 = { ff15???????? c705????????00000000 c3 3b0d???????? 7502 f3c3 e9???????? }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   c3                   | ret                 
            //   3b0d????????         |                     
            //   7502                 | jne                 4
            //   f3c3                 | ret                 
            //   e9????????           |                     

        $sequence_9 = { 56 57 68e7070000 50 ff15???????? ff05???????? }
            // n = 6, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   68e7070000           | push                0x7e7
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff05????????         |                     

    condition:
        7 of them and filesize < 499712
}