rule win_pupy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pupy"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 83c418 85c0 7504 33c0 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 50 6804010000 ff15???????? 833d????????00 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   833d????????00       |                     

        $sequence_2 = { 6afd 58 eb39 8d45dc 50 ff15???????? }
            // n = 6, score = 200
            //   6afd                 | push                -3
            //   58                   | pop                 eax
            //   eb39                 | jmp                 0x3b
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_3 = { 7728 8b5508 8d45e0 e8???????? 85c0 7478 }
            // n = 6, score = 200
            //   7728                 | ja                  0x2a
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7478                 | je                  0x7a

        $sequence_4 = { ff15???????? 8bf8 85ff 7511 53 ff15???????? 8bf8 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7511                 | jne                 0x13
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 59 c7461001000000 8935???????? 8bc6 5e }
            // n = 5, score = 200
            //   59                   | pop                 ecx
            //   c7461001000000       | mov                 dword ptr [esi + 0x10], 1
            //   8935????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_6 = { 3bfb 7410 57 ff15???????? 57 ff15???????? ebc8 }
            // n = 7, score = 200
            //   3bfb                 | cmp                 edi, ebx
            //   7410                 | je                  0x12
            //   57                   | push                edi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ebc8                 | jmp                 0xffffffca

        $sequence_7 = { 83c002 50 ff75f8 ff5620 83c40c 8907 }
            // n = 6, score = 200
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff5620               | call                dword ptr [esi + 0x20]
            //   83c40c               | add                 esp, 0xc
            //   8907                 | mov                 dword ptr [edi], eax

        $sequence_8 = { b84c010000 66394704 7506 f6473801 7412 68c1000000 ff15???????? }
            // n = 7, score = 200
            //   b84c010000           | mov                 eax, 0x14c
            //   66394704             | cmp                 word ptr [edi + 4], ax
            //   7506                 | jne                 8
            //   f6473801             | test                byte ptr [edi + 0x38], 1
            //   7412                 | je                  0x14
            //   68c1000000           | push                0xc1
            //   ff15????????         |                     

        $sequence_9 = { 7517 8b8db8efffff 0fb711 8b85c0efffff 2bc2 8985b4efffff }
            // n = 6, score = 100
            //   7517                 | jne                 0x19
            //   8b8db8efffff         | mov                 ecx, dword ptr [ebp - 0x1048]
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   8b85c0efffff         | mov                 eax, dword ptr [ebp - 0x1040]
            //   2bc2                 | sub                 eax, edx
            //   8985b4efffff         | mov                 dword ptr [ebp - 0x104c], eax

        $sequence_10 = { 8b55e8 52 e8???????? 83c404 837ddc00 }
            // n = 5, score = 100
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   837ddc00             | cmp                 dword ptr [ebp - 0x24], 0

        $sequence_11 = { c745e400000000 33c9 894de8 8b55f8 8b02 8945e8 }
            // n = 6, score = 100
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   33c9                 | xor                 ecx, ecx
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax

        $sequence_12 = { 7511 25ff0f0000 8bce 03c2 }
            // n = 4, score = 100
            //   7511                 | jne                 0x13
            //   25ff0f0000           | and                 eax, 0xfff
            //   8bce                 | mov                 ecx, esi
            //   03c2                 | add                 eax, edx

        $sequence_13 = { 5e 33d2 b9???????? 57 8bc2 c1f805 8b048560996910 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   33d2                 | xor                 edx, edx
            //   b9????????           |                     
            //   57                   | push                edi
            //   8bc2                 | mov                 eax, edx
            //   c1f805               | sar                 eax, 5
            //   8b048560996910       | mov                 eax, dword ptr [eax*4 + 0x10699960]

        $sequence_14 = { 8b85c4fcffff 50 8b8dc4fcffff 51 8b95a8fcffff }
            // n = 5, score = 100
            //   8b85c4fcffff         | mov                 eax, dword ptr [ebp - 0x33c]
            //   50                   | push                eax
            //   8b8dc4fcffff         | mov                 ecx, dword ptr [ebp - 0x33c]
            //   51                   | push                ecx
            //   8b95a8fcffff         | mov                 edx, dword ptr [ebp - 0x358]

    condition:
        7 of them and filesize < 23422976
}