rule win_purplefox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.purplefox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.purplefox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b15???????? 53 8a1d???????? 6a01 8906 }
            // n = 5, score = 100
            //   8b15????????         |                     
            //   53                   | dec                 esp
            //   8a1d????????         |                     
            //   6a01                 | lea                 edx, [ebp + ebp*2]
            //   8906                 | dec                 esp

        $sequence_1 = { 8945f4 3bc7 740d 8b7308 }
            // n = 4, score = 100
            //   8945f4               | lea                 ecx, [esi + 0x1c]
            //   3bc7                 | xor                 edx, edx
            //   740d                 | inc                 ecx
            //   8b7308               | mov                 eax, 0x101

        $sequence_2 = { c1fa05 c1e006 030495000c4100 eb05 b8???????? f6400420 }
            // n = 6, score = 100
            //   c1fa05               | pop                 ebx
            //   c1e006               | ret                 
            //   030495000c4100       | cmp                 dword ptr [eax], ebx
            //   eb05                 | cmovl               ebx, dword ptr [eax]
            //   b8????????           |                     
            //   f6400420             | cmp                 ecx, ebx

        $sequence_3 = { 85c0 7912 488b8d90010000 ff15???????? e9???????? 488b8d98010000 4533c9 }
            // n = 7, score = 100
            //   85c0                 | dec                 eax
            //   7912                 | cmp                 dword ptr [esp + 0x70], eax
            //   488b8d90010000       | jne                 0xb9
            //   ff15????????         |                     
            //   e9????????           |                     
            //   488b8d98010000       | dec                 eax
            //   4533c9               | lea                 edx, [esp + 0x60]

        $sequence_4 = { 8bcf e8???????? e9???????? 488d0df6200000 ff15???????? 488b3b }
            // n = 6, score = 100
            //   8bcf                 | mov                 word ptr [ecx - 2], ax
            //   e8????????           |                     
            //   e9????????           |                     
            //   488d0df6200000       | test                ax, ax
            //   ff15????????         |                     
            //   488b3b               | jne                 0xfffffff5

        $sequence_5 = { 6800000010 8d45f8 bf40020000 50 c745c018000000 895dc4 }
            // n = 6, score = 100
            //   6800000010           | push                0x10000000
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   bf40020000           | mov                 edi, 0x240
            //   50                   | push                eax
            //   c745c018000000       | mov                 dword ptr [ebp - 0x40], 0x18
            //   895dc4               | mov                 dword ptr [ebp - 0x3c], ebx

        $sequence_6 = { 488d4e1c 33d2 41b801010000 e8???????? 4c8d546d00 4c8d1db0920000 49c1e204 }
            // n = 7, score = 100
            //   488d4e1c             | pop                 eax
            //   33d2                 | mov                 bh, byte ptr [edi]
            //   41b801010000         | pop                 eax
            //   e8????????           |                     
            //   4c8d546d00           | jbe                 0x4a
            //   4c8d1db0920000       | xor                 eax, 0xd37d93fd
            //   49c1e204             | inc                 ebx

        $sequence_7 = { 66b8f230 8b4500 f9 f9 e9???????? }
            // n = 5, score = 100
            //   66b8f230             | lea                 ecx, [0x11ca]
            //   8b4500               | dec                 esp
            //   f9                   | mov                 eax, esi
            //   f9                   | dec                 eax
            //   e9????????           |                     

        $sequence_8 = { ff15???????? 488d542440 488d0dca110000 4c8bc6 ff15???????? 488d4c2440 41b001 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d542440           | xor                 eax, eax
            //   488d0dca110000       | sub                 ecx, 0x222000
            //   4c8bc6               | mov                 esi, 0xc0000010
            //   ff15????????         |                     
            //   488d4c2440           | je                  0x2f7
            //   41b001               | sub                 ecx, 4

        $sequence_9 = { 57 4883ec60 48c7442440feffffff 48899c2488000000 }
            // n = 4, score = 100
            //   57                   | rol                 cl, 7
            //   4883ec60             | shr                 cl, cl
            //   48c7442440feffffff     | leave    
            //   48899c2488000000     | dec                 ecx

        $sequence_10 = { 8b7de8 56 8d8dacfbffff 51 8d55b0 52 }
            // n = 6, score = 100
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   56                   | push                esi
            //   8d8dacfbffff         | lea                 ecx, [ebp - 0x454]
            //   51                   | push                ecx
            //   8d55b0               | lea                 edx, [ebp - 0x50]
            //   52                   | push                edx

        $sequence_11 = { 8da42400000000 8038ff 750b 80780175 7505 385802 7409 }
            // n = 7, score = 100
            //   8da42400000000       | dec                 eax
            //   8038ff               | sub                 esp, 0x60
            //   750b                 | dec                 eax
            //   80780175             | mov                 dword ptr [esp + 0x40], 0xfffffffe
            //   7505                 | dec                 eax
            //   385802               | mov                 dword ptr [esp + 0x88], ebx
            //   7409                 | dec                 eax

        $sequence_12 = { c9 49 3658 8a3f 3658 7642 }
            // n = 6, score = 100
            //   c9                   | pop                 eax
            //   49                   | ja                  0x40
            //   3658                 | xor                 edi, ecx
            //   8a3f                 | adc                 ecx, ecx
            //   3658                 | push                esi
            //   7642                 | adc                 bl, byte ptr [eax + 0x1a]

        $sequence_13 = { 4889442430 488b05???????? c644242800 488b08 ba00020000 48894c2420 }
            // n = 6, score = 100
            //   4889442430           | dec                 eax
            //   488b05????????       |                     
            //   c644242800           | mov                 ecx, dword ptr [ebp + 0x408]
            //   488b08               | dec                 eax
            //   ba00020000           | mov                 dword ptr [esp + 0x30], eax
            //   48894c2420           | mov                 byte ptr [esp + 0x28], 0

        $sequence_14 = { ff15???????? 8bf0 85f6 7914 56 68???????? ffd3 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7914                 | jns                 0x16
            //   56                   | push                esi
            //   68????????           |                     
            //   ffd3                 | call                ebx

        $sequence_15 = { ebcf 8bc6 c1f805 8b0485000c4100 83e61f c1e606 8d443004 }
            // n = 7, score = 100
            //   ebcf                 | lea                 ebx, [0x92b0]
            //   8bc6                 | dec                 ecx
            //   c1f805               | shl                 edx, 4
            //   8b0485000c4100       | dec                 eax
            //   83e61f               | lea                 ecx, [esp + 0x20]
            //   c1e606               | xor                 edx, edx
            //   8d443004             | dec                 eax

        $sequence_16 = { 35fd937dd3 43 d0f2 2f 4a 87cd }
            // n = 6, score = 100
            //   35fd937dd3           | mov                 byte ptr [esi - 0x5c], bh
            //   43                   | cmp                 eax, 0xc2083a0b
            //   d0f2                 | pushfd              
            //   2f                   | pushal              
            //   4a                   | mov                 byte ptr [esp + 4], 0x3e
            //   87cd                 | cmc                 

        $sequence_17 = { 448bc6 442bc0 488b442450 488d0d4b7e0000 488b0cc1 }
            // n = 5, score = 100
            //   448bc6               | sti                 
            //   442bc0               | jg                  0xffffffb8
            //   488b442450           | movzx               dx, cl
            //   488d0d4b7e0000       | stc                 
            //   488b0cc1             | mov                 edx, dword ptr [ebp + 4]

        $sequence_18 = { 56 12581a 887ea4 3d0b3a08c2 }
            // n = 4, score = 100
            //   56                   | inc                 ebp
            //   12581a               | xor                 eax, eax
            //   887ea4               | dec                 eax
            //   3d0b3a08c2           | mov                 dword ptr [esp + 0x30], eax

        $sequence_19 = { 83c408 6a00 51 ff15???????? 8bf0 }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_20 = { 51 e8???????? 83c404 8b5704 68???????? }
            // n = 5, score = 100
            //   51                   | dec                 eax
            //   e8????????           |                     
            //   83c404               | cmp                 eax, 0x3c
            //   8b5704               | jbe                 0x4d
            //   68????????           |                     

        $sequence_21 = { 81e900202200 be100000c0 0f84ec020000 83e904 0f8486010000 83e904 }
            // n = 6, score = 100
            //   81e900202200         | dec                 eax
            //   be100000c0           | mov                 ecx, dword ptr [ebp + 0x198]
            //   0f84ec020000         | inc                 ebp
            //   83e904               | xor                 ecx, ecx
            //   0f8486010000         | dec                 eax
            //   83e904               | add                 edx, 2

        $sequence_22 = { 3918 0f4c18 3bcb 0f8d87000000 488d3dd7b70000 ba58000000 488bcd }
            // n = 7, score = 100
            //   3918                 | push                0x329f6228
            //   0f4c18               | mov                 dword ptr ss:[eax], edx
            //   3bcb                 | dec                 eax
            //   0f8d87000000         | sub                 esp, 0x20
            //   488d3dd7b70000       | dec                 eax
            //   ba58000000           | mov                 ebx, ecx
            //   488bcd               | dec                 esp

        $sequence_23 = { 9c 60 c64424043e f5 }
            // n = 4, score = 100
            //   9c                   | mov                 byte ptr [esp + 0x28], 0
            //   60                   | dec                 eax
            //   c64424043e           | lea                 edx, [esp + 0x40]
            //   f5                   | dec                 eax

        $sequence_24 = { 488b4c2470 ff15???????? 488b8d08040000 ff15???????? }
            // n = 4, score = 100
            //   488b4c2470           | dec                 eax
            //   ff15????????         |                     
            //   488b8d08040000       | mov                 ecx, dword ptr [esp + 0x70]
            //   ff15????????         |                     

        $sequence_25 = { 57 56 6a0b ffd3 3d040000c0 750d }
            // n = 6, score = 100
            //   57                   | jge                 0x8f
            //   56                   | dec                 eax
            //   6a0b                 | lea                 edi, [0xb7d7]
            //   ffd3                 | mov                 edx, 0x58
            //   3d040000c0           | dec                 eax
            //   750d                 | mov                 ecx, ebp

        $sequence_26 = { 85c0 790a 8b4df8 ffd3 e9???????? }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   790a                 | jns                 0xc
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   ffd3                 | call                ebx
            //   e9????????           |                     

        $sequence_27 = { 58 773d 33f9 13c9 }
            // n = 4, score = 100
            //   58                   | dec                 eax
            //   773d                 | mov                 edi, dword ptr [ebx]
            //   33f9                 | inc                 ecx
            //   13c9                 | mov                 ecx, 0x80000000

        $sequence_28 = { e8???????? 33ff 33c0 8945f4 8945f0 8945f8 8b450c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33ff                 | mov                 dword ptr [esp + 0x20], eax
            //   33c0                 | dec                 eax
            //   8945f4               | mov                 ecx, dword ptr [ebx + 8]
            //   8945f0               | mov                 dword ptr [ebx], 0
            //   8945f8               | dec                 eax
            //   8b450c               | add                 esp, 0x20

        $sequence_29 = { c740e40d000000 8b55f8 8950e8 8b4660 }
            // n = 4, score = 100
            //   c740e40d000000       | mov                 dword ptr [eax - 0x1c], 0xd
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8950e8               | mov                 dword ptr [eax - 0x18], edx
            //   8b4660               | mov                 eax, dword ptr [esi + 0x60]

        $sequence_30 = { 488d4c2420 33d2 4889442420 8b05???????? }
            // n = 4, score = 100
            //   488d4c2420           | sal                 dl, 1
            //   33d2                 | das                 
            //   4889442420           | dec                 edx
            //   8b05????????         |                     

        $sequence_31 = { 4883f83c 7647 498bcd e8???????? 4c8d05436c0000 41b903000000 488d4c45bc }
            // n = 7, score = 100
            //   4883f83c             | lea                 ebx, [0xa117]
            //   7647                 | inc                 esp
            //   498bcd               | mov                 eax, esi
            //   e8????????           |                     
            //   4c8d05436c0000       | inc                 esp
            //   41b903000000         | sub                 eax, eax
            //   488d4c45bc           | dec                 eax

        $sequence_32 = { 488b4b08 ff15???????? c70300000000 4883c420 5b c3 }
            // n = 6, score = 100
            //   488b4b08             | xchg                ebp, ecx
            //   ff15????????         |                     
            //   c70300000000         | and                 ebx, 0xff0
            //   4883c420             | pushal              
            //   5b                   | cmp                 ebx, 0xfe0
            //   c3                   | pushfd              

        $sequence_33 = { 4883c202 668941fe 6685c0 75ec 488b7e08 4883c9ff 33c0 }
            // n = 7, score = 100
            //   4883c202             | dec                 eax
            //   668941fe             | mov                 ecx, esi
            //   6685c0               | test                eax, eax
            //   75ec                 | test                eax, eax
            //   488b7e08             | jns                 0x14
            //   4883c9ff             | dec                 eax
            //   33c0                 | mov                 ecx, dword ptr [ebp + 0x190]

        $sequence_34 = { 4883ec20 488bd9 e8???????? 4c8d1d17a10000 }
            // n = 4, score = 100
            //   4883ec20             | arpl                word ptr [edx + ebp*8 + 0x1c], cx
            //   488bd9               | mov                 esp, 0xebefed2c
            //   e8????????           |                     
            //   4c8d1d17a10000       | pop                 ecx

        $sequence_35 = { ff15???????? 4839442470 0f85b3000000 488d542460 488bce ff15???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   4839442470           | dec                 eax
            //   0f85b3000000         | mov                 ecx, dword ptr [eax]
            //   488d542460           | mov                 edx, 0x200
            //   488bce               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | mov                 dword ptr [esp + 0x20], ecx

        $sequence_36 = { e9???????? 660fb6d1 f9 8b5504 c0c107 d2e9 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   660fb6d1             | mov                 edi, dword ptr [esp + 0x4b8]
            //   f9                   | dec                 eax
            //   8b5504               | mov                 ebx, dword ptr [esp + 0x4b0]
            //   c0c107               | inc                 ecx
            //   d2e9                 | mov                 dword ptr [esp + 0x30], esi

        $sequence_37 = { 57 f361 634cea1c bc2cedefeb 59 fb 7fab }
            // n = 7, score = 100
            //   57                   | lea                 ecx, [esp + 0x40]
            //   f361                 | inc                 ecx
            //   634cea1c             | mov                 al, 1
            //   bc2cedefeb           | dec                 eax
            //   59                   | lea                 ecx, [esp + 0x40]
            //   fb                   | mov                 esi, eax
            //   7fab                 | dec                 eax

        $sequence_38 = { 7506 50 e9???????? 8b55ec }
            // n = 4, score = 100
            //   7506                 | jne                 8
            //   50                   | push                eax
            //   e9????????           |                     
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_39 = { 56 68???????? ff15???????? 83c408 8bc6 5e 8be5 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   68????????           |                     
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

    condition:
        7 of them and filesize < 1983488
}