rule win_purplewave_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.purplewave."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.purplewave"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc1 c1f806 83e13f 6bc938 8b0485201e4900 80640828fe ff36 }
            // n = 7, score = 400
            //   8bc1                 | mov                 eax, ecx
            //   c1f806               | sar                 eax, 6
            //   83e13f               | and                 ecx, 0x3f
            //   6bc938               | imul                ecx, ecx, 0x38
            //   8b0485201e4900       | mov                 eax, dword ptr [eax*4 + 0x491e20]
            //   80640828fe           | and                 byte ptr [eax + ecx + 0x28], 0xfe
            //   ff36                 | push                dword ptr [esi]

        $sequence_1 = { 395914 7202 8b09 85f6 7410 8bd1 66833a3a }
            // n = 7, score = 400
            //   395914               | cmp                 dword ptr [ecx + 0x14], ebx
            //   7202                 | jb                  4
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12
            //   8bd1                 | mov                 edx, ecx
            //   66833a3a             | cmp                 word ptr [edx], 0x3a

        $sequence_2 = { 59 8945c0 894dc4 8845b0 8945d8 894ddc }
            // n = 6, score = 400
            //   59                   | pop                 ecx
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   894dc4               | mov                 dword ptr [ebp - 0x3c], ecx
            //   8845b0               | mov                 byte ptr [ebp - 0x50], al
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx

        $sequence_3 = { 8bec 8b5508 56 0fb67203 0fb64202 0fb64a01 c1e608 }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   0fb67203             | movzx               esi, byte ptr [edx + 3]
            //   0fb64202             | movzx               eax, byte ptr [edx + 2]
            //   0fb64a01             | movzx               ecx, byte ptr [edx + 1]
            //   c1e608               | shl                 esi, 8

        $sequence_4 = { 8d8d14ffffff e8???????? 68???????? 8d8d14ffffff c645fc20 e8???????? 50 }
            // n = 7, score = 400
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]
            //   c645fc20             | mov                 byte ptr [ebp - 4], 0x20
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 51 8d4dd4 e8???????? ff734c e8???????? 59 3bc7 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   ff734c               | push                dword ptr [ebx + 0x4c]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   3bc7                 | cmp                 eax, edi

        $sequence_6 = { 8b4e08 8902 894a04 895004 8911 8b4508 }
            // n = 6, score = 400
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]
            //   8902                 | mov                 dword ptr [edx], eax
            //   894a04               | mov                 dword ptr [edx + 4], ecx
            //   895004               | mov                 dword ptr [eax + 4], edx
            //   8911                 | mov                 dword ptr [ecx], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 8d7b04 899d5cfdffff 33c0 c703???????? 83671000 c7471407000000 668907 }
            // n = 7, score = 400
            //   8d7b04               | lea                 edi, [ebx + 4]
            //   899d5cfdffff         | mov                 dword ptr [ebp - 0x2a4], ebx
            //   33c0                 | xor                 eax, eax
            //   c703????????         |                     
            //   83671000             | and                 dword ptr [edi + 0x10], 0
            //   c7471407000000       | mov                 dword ptr [edi + 0x14], 7
            //   668907               | mov                 word ptr [edi], ax

        $sequence_8 = { 8d8d14ffffff e8???????? 68???????? 8d8d14ffffff c645fc60 e8???????? 50 }
            // n = 7, score = 400
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8d14ffffff         | lea                 ecx, [ebp - 0xec]
            //   c645fc60             | mov                 byte ptr [ebp - 4], 0x60
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_9 = { e9???????? c3 8d4db0 e9???????? 8d4dbc e9???????? 8d8df8fbffff }
            // n = 7, score = 400
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   e9????????           |                     
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   e9????????           |                     
            //   8d8df8fbffff         | lea                 ecx, [ebp - 0x408]

    condition:
        7 of them and filesize < 1400832
}