rule win_pushdo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pushdo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pushdo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7f9 33c9 ba88020000 f7e2 }
            // n = 4, score = 1300
            //   f7f9                 | idiv                ecx
            //   33c9                 | xor                 ecx, ecx
            //   ba88020000           | mov                 edx, 0x288
            //   f7e2                 | mul                 edx

        $sequence_1 = { 50 ff15???????? 33d2 b9ffff0000 f7f1 }
            // n = 5, score = 1300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx
            //   b9ffff0000           | mov                 ecx, 0xffff
            //   f7f1                 | div                 ecx

        $sequence_2 = { 60 8b45fc b10b d3c0 61 }
            // n = 5, score = 1200
            //   60                   | pushal              
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   b10b                 | mov                 cl, 0xb
            //   d3c0                 | rol                 eax, cl
            //   61                   | popal               

        $sequence_3 = { 8a85effeffff 888415f0feffff 8b4d08 034dfc 0fbe11 }
            // n = 5, score = 800
            //   8a85effeffff         | mov                 al, byte ptr [ebp - 0x111]
            //   888415f0feffff       | mov                 byte ptr [ebp + edx - 0x110], al
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034dfc               | add                 ecx, dword ptr [ebp - 4]
            //   0fbe11               | movsx               edx, byte ptr [ecx]

        $sequence_4 = { 81ec18010000 6800010000 6a00 8d85f0feffff 50 e8???????? }
            // n = 6, score = 800
            //   81ec18010000         | sub                 esp, 0x118
            //   6800010000           | push                0x100
            //   6a00                 | push                0
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 8b55fc 3b5510 0f83a6000000 8b45f4 83c001 25ff000000 }
            // n = 6, score = 800
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   3b5510               | cmp                 edx, dword ptr [ebp + 0x10]
            //   0f83a6000000         | jae                 0xac
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c001               | add                 eax, 1
            //   25ff000000           | and                 eax, 0xff

        $sequence_6 = { 8b450c 0345fc 8810 e9???????? 8be5 }
            // n = 5, score = 800
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   0345fc               | add                 eax, dword ptr [ebp - 4]
            //   8810                 | mov                 byte ptr [eax], dl
            //   e9????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { 8b55fc 83c201 8955fc 817dfc00010000 736a 8b45fc }
            // n = 6, score = 800
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   83c201               | add                 edx, 1
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   817dfc00010000       | cmp                 dword ptr [ebp - 4], 0x100
            //   736a                 | jae                 0x6c
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_8 = { 03c2 c1f808 49 79dd }
            // n = 4, score = 600
            //   03c2                 | add                 eax, edx
            //   c1f808               | sar                 eax, 8
            //   49                   | dec                 ecx
            //   79dd                 | jns                 0xffffffdf

        $sequence_9 = { ff15???????? 8945fc 3bc7 0f84a1010000 8d45ec 50 8d4598 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3bc7                 | cmp                 eax, edi
            //   0f84a1010000         | je                  0x1a7
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   8d4598               | lea                 eax, [ebp - 0x68]

        $sequence_10 = { 7413 8d45f8 50 8d85f0fdffff 50 }
            // n = 5, score = 600
            //   7413                 | je                  0x15
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax

        $sequence_11 = { 6a04 bb00300000 53 bf00100000 }
            // n = 4, score = 600
            //   6a04                 | push                4
            //   bb00300000           | mov                 ebx, 0x3000
            //   53                   | push                ebx
            //   bf00100000           | mov                 edi, 0x1000

        $sequence_12 = { 0f849f000000 8d45f8 50 6801008000 6801680000 ff75fc }
            // n = 6, score = 600
            //   0f849f000000         | je                  0xa5
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6801008000           | push                0x800001
            //   6801680000           | push                0x6801
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_13 = { 52 8d8588fbffff 50 e8???????? }
            // n = 4, score = 500
            //   52                   | push                edx
            //   8d8588fbffff         | lea                 eax, [ebp - 0x478]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_14 = { 8b5508 8b02 8945f4 837df400 741a 8b4df4 }
            // n = 6, score = 200
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   741a                 | je                  0x1c
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_15 = { e8???????? 898544feffff 8b8544feffff 33d2 b90a000000 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   898544feffff         | mov                 dword ptr [ebp - 0x1bc], eax
            //   8b8544feffff         | mov                 eax, dword ptr [ebp - 0x1bc]
            //   33d2                 | xor                 edx, edx
            //   b90a000000           | mov                 ecx, 0xa

        $sequence_16 = { 8bff 55 8bec 8b450c c1e810 }
            // n = 5, score = 200
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   c1e810               | shr                 eax, 0x10

        $sequence_17 = { eb0f 8b9570fdffff 83c201 899570fdffff 83bd70fdffff14 }
            // n = 5, score = 200
            //   eb0f                 | jmp                 0x11
            //   8b9570fdffff         | mov                 edx, dword ptr [ebp - 0x290]
            //   83c201               | add                 edx, 1
            //   899570fdffff         | mov                 dword ptr [ebp - 0x290], edx
            //   83bd70fdffff14       | cmp                 dword ptr [ebp - 0x290], 0x14

        $sequence_18 = { 2b4dfc 3b4dec 7307 33c0 e9???????? 8b55fc }
            // n = 6, score = 200
            //   2b4dfc               | sub                 ecx, dword ptr [ebp - 4]
            //   3b4dec               | cmp                 ecx, dword ptr [ebp - 0x14]
            //   7307                 | jae                 9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_19 = { e8???????? 8945b8 6a6c 8b4db8 51 e8???????? 8945b8 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   6a6c                 | push                0x6c
            //   8b4db8               | mov                 ecx, dword ptr [ebp - 0x48]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax

        $sequence_20 = { 55 8bec 0fb6450c c1f804 83e00f 8b4d08 8a906c520009 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   0fb6450c             | movzx               eax, byte ptr [ebp + 0xc]
            //   c1f804               | sar                 eax, 4
            //   83e00f               | and                 eax, 0xf
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8a906c520009         | mov                 dl, byte ptr [eax + 0x900526c]

    condition:
        7 of them and filesize < 163840
}