rule win_putabmow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.putabmow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.putabmow"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6200 3100 680032006f 0033 0010 0035???????? 007b00 }
            // n = 7, score = 100
            //   6200                 | bound               eax, qword ptr [eax]
            //   3100                 | xor                 dword ptr [eax], eax
            //   680032006f           | push                0x6f003200
            //   0033                 | add                 byte ptr [ebx], dh
            //   0010                 | add                 byte ptr [eax], dl
            //   0035????????         |                     
            //   007b00               | add                 byte ptr [ebx], bh

        $sequence_1 = { e8???????? c645fc06 8b467c 89477c 8b8680000000 898780000000 8b8684000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c645fc06             | mov                 byte ptr [ebp - 4], 6
            //   8b467c               | mov                 eax, dword ptr [esi + 0x7c]
            //   89477c               | mov                 dword ptr [edi + 0x7c], eax
            //   8b8680000000         | mov                 eax, dword ptr [esi + 0x80]
            //   898780000000         | mov                 dword ptr [edi + 0x80], eax
            //   8b8684000000         | mov                 eax, dword ptr [esi + 0x84]

        $sequence_2 = { 32db c78424200b000021000000 8b442418 a802 }
            // n = 4, score = 100
            //   32db                 | xor                 bl, bl
            //   c78424200b000021000000     | mov    dword ptr [esp + 0xb20], 0x21
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   a802                 | test                al, 2

        $sequence_3 = { c1f905 83e107 094828 8a5201 f6c204 7404 83482810 }
            // n = 7, score = 100
            //   c1f905               | sar                 ecx, 5
            //   83e107               | and                 ecx, 7
            //   094828               | or                  dword ptr [eax + 0x28], ecx
            //   8a5201               | mov                 dl, byte ptr [edx + 1]
            //   f6c204               | test                dl, 4
            //   7404                 | je                  6
            //   83482810             | or                  dword ptr [eax + 0x28], 0x10

        $sequence_4 = { 3901 61 0039 016200 3f 016300 3f }
            // n = 7, score = 100
            //   3901                 | cmp                 dword ptr [ecx], eax
            //   61                   | popal               
            //   0039                 | add                 byte ptr [ecx], bh
            //   016200               | add                 dword ptr [edx], esp
            //   3f                   | aas                 
            //   016300               | add                 dword ptr [ebx], esp
            //   3f                   | aas                 

        $sequence_5 = { 8b4df8 8bd6 ff75e8 57 ff75f0 6a00 50 }
            // n = 7, score = 100
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8bd6                 | mov                 edx, esi
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   57                   | push                edi
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_6 = { 8d8c24b0070000 ff30 e8???????? c68424200b00004c 8d8424e0000000 50 8d8c24f8040000 }
            // n = 7, score = 100
            //   8d8c24b0070000       | lea                 ecx, [esp + 0x7b0]
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   c68424200b00004c     | mov                 byte ptr [esp + 0xb20], 0x4c
            //   8d8424e0000000       | lea                 eax, [esp + 0xe0]
            //   50                   | push                eax
            //   8d8c24f8040000       | lea                 ecx, [esp + 0x4f8]

        $sequence_7 = { c684249404000000 84db 0f8493010000 f7462800004000 8d5618 7502 8b12 }
            // n = 7, score = 100
            //   c684249404000000     | mov                 byte ptr [esp + 0x494], 0
            //   84db                 | test                bl, bl
            //   0f8493010000         | je                  0x199
            //   f7462800004000       | test                dword ptr [esi + 0x28], 0x400000
            //   8d5618               | lea                 edx, [esi + 0x18]
            //   7502                 | jne                 4
            //   8b12                 | mov                 edx, dword ptr [edx]

        $sequence_8 = { 3bf1 7608 89442420 2bf1 eb02 33f6 8b4314 }
            // n = 7, score = 100
            //   3bf1                 | cmp                 esi, ecx
            //   7608                 | jbe                 0xa
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   2bf1                 | sub                 esi, ecx
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]

        $sequence_9 = { 888630977300 46 ebe5 a1???????? 83c9ff f00fc108 7513 }
            // n = 7, score = 100
            //   888630977300         | mov                 byte ptr [esi + 0x739730], al
            //   46                   | inc                 esi
            //   ebe5                 | jmp                 0xffffffe7
            //   a1????????           |                     
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f00fc108             | lock xadd           dword ptr [eax], ecx
            //   7513                 | jne                 0x15

    condition:
        7 of them and filesize < 704512
}