rule win_puzzlemaker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.puzzlemaker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.puzzlemaker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c74078feffffff 83ffff 0f8c60040000 41837e0800 4c8d05b7b6ffff }
            // n = 5, score = 100
            //   c74078feffffff       | dec                 eax
            //   83ffff               | mov                 dword ptr [esp + 0x20], eax
            //   0f8c60040000         | dec                 esp
            //   41837e0800           | lea                 ecx, [0x145f9]
            //   4c8d05b7b6ffff       | xor                 edx, edx

        $sequence_1 = { 4883ec20 8bfa 4c8d0d25a00000 488bd9 488d151ba00000 b916000000 4c8d0507a00000 }
            // n = 7, score = 100
            //   4883ec20             | dec                 edx
            //   8bfa                 | mov                 eax, dword ptr [eax + ebp*8]
            //   4c8d0d25a00000       | inc                 edx
            //   488bd9               | cmp                 byte ptr [eax + edi*8 + 0x39], bl
            //   488d151ba00000       | je                  0x117f
            //   b916000000           | dec                 eax
            //   4c8d0507a00000       | lea                 eax, [0xfd79]

        $sequence_2 = { 448bc0 4c8d157d0a0200 0f1f4000 660f1f840000000000 410fb6d0 420fb60c12 }
            // n = 6, score = 100
            //   448bc0               | dec                 eax
            //   4c8d157d0a0200       | lea                 ecx, [ebp - 0x78]
            //   0f1f4000             | dec                 eax
            //   660f1f840000000000     | lea    edx, [0x1b16b]
            //   410fb6d0             | dec                 eax
            //   420fb60c12           | lea                 ecx, [ebp - 0x78]

        $sequence_3 = { 488905???????? 4885c0 7551 488b0d???????? 488d157c160200 }
            // n = 5, score = 100
            //   488905????????       |                     
            //   4885c0               | lea                 ecx, [0x1f983]
            //   7551                 | mov                 ecx, edi
            //   488b0d????????       |                     
            //   488d157c160200       | dec                 eax

        $sequence_4 = { 4c8d0d3da30000 33c9 4c8d0530a30000 488d1531a30000 e8???????? 4885c0 }
            // n = 6, score = 100
            //   4c8d0d3da30000       | lea                 ecx, [eax + 0x20]
            //   33c9                 | int                 0x29
            //   4c8d0530a30000       | dec                 eax
            //   488d1531a30000       | lea                 ecx, [0x1fa6b]
            //   e8????????           |                     
            //   4885c0               | dec                 eax

        $sequence_5 = { ff15???????? 4c8be0 4c896ddf 488b4dc7 488b11 4c8b5230 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4c8be0               | shr                 eax, cl
            //   4c896ddf             | inc                 edx
            //   488b4dc7             | mov                 cl, byte ptr [ecx + ebx + 0x164c8]
            //   488b11               | dec                 esp
            //   4c8b5230             | sub                 eax, eax

        $sequence_6 = { e8???????? 488db328010000 bd06000000 488d7b38 488d05462d0100 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488db328010000       | lea                 eax, [0x13a07]
            //   bd06000000           | dec                 eax
            //   488d7b38             | mov                 edi, ecx
            //   488d05462d0100       | dec                 eax

        $sequence_7 = { 84c0 7421 4885db 750b 488d1d83f20000 48895f48 4863d6 }
            // n = 7, score = 100
            //   84c0                 | lea                 ecx, [ebx + ebx*4]
            //   7421                 | dec                 eax
            //   4885db               | lea                 ecx, [eax + ecx*8]
            //   750b                 | jmp                 0x158c
            //   488d1d83f20000       | dec                 eax
            //   48895f48             | mov                 eax, ebx
            //   4863d6               | dec                 ecx

        $sequence_8 = { 7410 41ffc0 4983c102 4181f880000000 72e1 448bc0 }
            // n = 6, score = 100
            //   7410                 | setne               dh
            //   41ffc0               | test                eax, eax
            //   4983c102             | je                  0x289
            //   4181f880000000       | cmp                 eax, 1
            //   72e1                 | jne                 0x2a4
            //   448bc0               | test                eax, eax

        $sequence_9 = { 418bd2 4d8b8cc7f02b0200 498bfa 4b8d04f1 443854383e }
            // n = 5, score = 100
            //   418bd2               | xor                 edx, edx
            //   4d8b8cc7f02b0200     | call                dword ptr [eax + 0x78]
            //   498bfa               | mov                 eax, 8
            //   4b8d04f1             | dec                 esp
            //   443854383e           | lea                 ecx, [ebp + 7]

    condition:
        7 of them and filesize < 331776
}