rule win_pwnpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pwnpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pwnpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? bb0b000000 52 899c2468020000 e8???????? 83c40c }
            // n = 6, score = 100
            //   68????????           |                     
            //   bb0b000000           | mov                 ebx, 0xb
            //   52                   | push                edx
            //   899c2468020000       | mov                 dword ptr [esp + 0x268], ebx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_1 = { 8b07 8b4004 3974380c 750f 8b44383c 3bc6 7407 }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   3974380c             | cmp                 dword ptr [eax + edi + 0xc], esi
            //   750f                 | jne                 0x11
            //   8b44383c             | mov                 eax, dword ptr [eax + edi + 0x3c]
            //   3bc6                 | cmp                 eax, esi
            //   7407                 | je                  9

        $sequence_2 = { 8bf0 33db 83c404 3bf3 742d 8d4e18 c7460401000000 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   33db                 | xor                 ebx, ebx
            //   83c404               | add                 esp, 4
            //   3bf3                 | cmp                 esi, ebx
            //   742d                 | je                  0x2f
            //   8d4e18               | lea                 ecx, [esi + 0x18]
            //   c7460401000000       | mov                 dword ptr [esi + 4], 1

        $sequence_3 = { 8d4df0 e8???????? 8b4d0c 895dfc 8b5f30 51 c745ec01000000 }
            // n = 7, score = 100
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8b5f30               | mov                 ebx, dword ptr [edi + 0x30]
            //   51                   | push                ecx
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1

        $sequence_4 = { 51 53 56 52 50 8d4c243c 51 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   52                   | push                edx
            //   50                   | push                eax
            //   8d4c243c             | lea                 ecx, [esp + 0x3c]
            //   51                   | push                ecx

        $sequence_5 = { 8b4d08 83c118 e9???????? 8b4d08 83c118 e9???????? }
            // n = 6, score = 100
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c118               | add                 ecx, 0x18
            //   e9????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c118               | add                 ecx, 0x18
            //   e9????????           |                     

        $sequence_6 = { 720f 8b95a0f9ffff 52 e8???????? 83c404 b001 8b4df4 }
            // n = 7, score = 100
            //   720f                 | jb                  0x11
            //   8b95a0f9ffff         | mov                 edx, dword ptr [ebp - 0x660]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   b001                 | mov                 al, 1
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_7 = { 57 57 57 57 57 8d85d8f9ffff 50 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   8d85d8f9ffff         | lea                 eax, [ebp - 0x628]
            //   50                   | push                eax

        $sequence_8 = { c705????????80b24300 c3 c705????????80b24300 c3 }
            // n = 4, score = 100
            //   c705????????80b24300     |     
            //   c3                   | ret                 
            //   c705????????80b24300     |     
            //   c3                   | ret                 

        $sequence_9 = { 0f871c020000 ff248dc86f4300 8d48cf 80f908 7706 }
            // n = 5, score = 100
            //   0f871c020000         | ja                  0x222
            //   ff248dc86f4300       | jmp                 dword ptr [ecx*4 + 0x436fc8]
            //   8d48cf               | lea                 ecx, [eax - 0x31]
            //   80f908               | cmp                 cl, 8
            //   7706                 | ja                  8

    condition:
        7 of them and filesize < 638976
}