rule win_pykspa_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pykspa."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pykspa"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 32c0 eb0d 2b4508 8d443004 39450c 0f9dc0 }
            // n = 6, score = 100
            //   32c0                 | xor                 al, al
            //   eb0d                 | jmp                 0xf
            //   2b4508               | sub                 eax, dword ptr [ebp + 8]
            //   8d443004             | lea                 eax, [eax + esi + 4]
            //   39450c               | cmp                 dword ptr [ebp + 0xc], eax
            //   0f9dc0               | setge               al

        $sequence_1 = { ff7524 68???????? e8???????? 83c40c 8d8500fcffff 50 8d8500d4ffff }
            // n = 7, score = 100
            //   ff7524               | push                dword ptr [ebp + 0x24]
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]
            //   50                   | push                eax
            //   8d8500d4ffff         | lea                 eax, [ebp - 0x2c00]

        $sequence_2 = { 53 ff15???????? e9???????? 8d85a0feffff 68???????? 50 e8???????? }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 8bf0 ff15???????? ff75cc 8bf8 e8???????? 3bf3 59 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   ff15????????         |                     
            //   ff75cc               | push                dword ptr [ebp - 0x34]
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   3bf3                 | cmp                 esi, ebx
            //   59                   | pop                 ecx

        $sequence_4 = { e9???????? 6a0a 8d45b0 50 8d858ceeffff 50 e8???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6a0a                 | push                0xa
            //   8d45b0               | lea                 eax, [ebp - 0x50]
            //   50                   | push                eax
            //   8d858ceeffff         | lea                 eax, [ebp - 0x1174]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 8bcb 83e107 c1e102 d3e8 a80f 7503 4b }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   83e107               | and                 ecx, 7
            //   c1e102               | shl                 ecx, 2
            //   d3e8                 | shr                 eax, cl
            //   a80f                 | test                al, 0xf
            //   7503                 | jne                 5
            //   4b                   | dec                 ebx

        $sequence_6 = { 50 6aff ff36 53 53 ff15???????? ff7508 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6aff                 | push                -1
            //   ff36                 | push                dword ptr [esi]
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 6a41 8d45bc 50 68???????? e8???????? 83c40c ff15???????? }
            // n = 7, score = 100
            //   6a41                 | push                0x41
            //   8d45bc               | lea                 eax, [ebp - 0x44]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff15????????         |                     

        $sequence_8 = { 53 e8???????? 8903 8d0436 83c40c 894708 6a02 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8903                 | mov                 dword ptr [ebx], eax
            //   8d0436               | lea                 eax, [esi + esi]
            //   83c40c               | add                 esp, 0xc
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   6a02                 | push                2

        $sequence_9 = { 7414 8d4580 50 8d4508 50 56 ff7510 }
            // n = 7, score = 100
            //   7414                 | je                  0x16
            //   8d4580               | lea                 eax, [ebp - 0x80]
            //   50                   | push                eax
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff7510               | push                dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 835584
}