rule win_qaccel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.qaccel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qaccel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f842b010000 8b7d0c 85ff 0f8420010000 8b4d10 85c9 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f842b010000         | je                  0x131
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   85ff                 | test                edi, edi
            //   0f8420010000         | je                  0x126
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   85c9                 | test                ecx, ecx

        $sequence_1 = { 0f880a000000 0f8904000000 5f 5f }
            // n = 4, score = 100
            //   0f880a000000         | js                  0x10
            //   0f8904000000         | jns                 0xa
            //   5f                   | pop                 edi
            //   5f                   | pop                 edi

        $sequence_2 = { 41 83c210 894df8 8b1b }
            // n = 4, score = 100
            //   41                   | inc                 ecx
            //   83c210               | add                 edx, 0x10
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b1b                 | mov                 ebx, dword ptr [ebx]

        $sequence_3 = { ff15???????? 50 ff15???????? 85db 7525 b941000000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85db                 | test                ebx, ebx
            //   7525                 | jne                 0x27
            //   b941000000           | mov                 ecx, 0x41

        $sequence_4 = { 8bf9 81e1ffff0000 83c102 51 ff15???????? 8bf0 }
            // n = 6, score = 100
            //   8bf9                 | mov                 edi, ecx
            //   81e1ffff0000         | and                 ecx, 0xffff
            //   83c102               | add                 ecx, 2
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 8b35???????? 83c408 ffd6 99 b91a000000 }
            // n = 5, score = 100
            //   8b35????????         |                     
            //   83c408               | add                 esp, 8
            //   ffd6                 | call                esi
            //   99                   | cdq                 
            //   b91a000000           | mov                 ecx, 0x1a

        $sequence_6 = { 5f 8b4d24 85c9 740a 8b45e0 }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]
            //   85c9                 | test                ecx, ecx
            //   740a                 | je                  0xc
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]

        $sequence_7 = { 85c0 0f8439010000 8b55fc 81e2ffff0000 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f8439010000         | je                  0x13f
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   81e2ffff0000         | and                 edx, 0xffff

        $sequence_8 = { 5f 8b86f0000000 8b550c 50 52 ff15???????? 83c408 }
            // n = 7, score = 100
            //   5f                   | pop                 edi
            //   8b86f0000000         | mov                 eax, dword ptr [esi + 0xf0]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8

        $sequence_9 = { 83c9ff f2ae f7d1 2bf9 8d95fcfeffff 8bf7 }
            // n = 6, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d95fcfeffff         | lea                 edx, [ebp - 0x104]
            //   8bf7                 | mov                 esi, edi

    condition:
        7 of them and filesize < 106496
}