rule win_quarterrig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.quarterrig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.quarterrig"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d95f0010000 488d4c2460 e8???????? 410fbaec07 4489642434 488d542460 48837c247810 }
            // n = 7, score = 100
            //   488d95f0010000       | xor                 eax, esp
            //   488d4c2460           | dec                 eax
            //   e8????????           |                     
            //   410fbaec07           | mov                 dword ptr [esp + 0x28], eax
            //   4489642434           | mov                 dword ptr [esp + 0x20], 0x35c590f9
            //   488d542460           | mov                 word ptr [esp + 0x24], 0x29f6
            //   48837c247810         | dec                 eax

        $sequence_1 = { 7506 443a5802 7420 498bc1 492bc2 4903c0 663b10 }
            // n = 7, score = 100
            //   7506                 | dec                 eax
            //   443a5802             | inc                 edx
            //   7420                 | dec                 eax
            //   498bc1               | mov                 ecx, dword ptr [ebp + 0x30]
            //   492bc2               | dec                 esp
            //   4903c0               | mov                 dword ptr [ebp + 0x40], edi
            //   663b10               | dec                 esp

        $sequence_2 = { 482bd7 4a0fbeb43850140600 8d4e01 4863c1 483bc2 0f8fe4010000 83f904 }
            // n = 7, score = 100
            //   482bd7               | xor                 eax, esp
            //   4a0fbeb43850140600     | jmp    0x1a15
            //   8d4e01               | dec                 eax
            //   4863c1               | mov                 ebx, esi
            //   483bc2               | dec                 eax
            //   0f8fe4010000         | cmp                 dword ptr [esi + 0x18], 0x10
            //   83f904               | jb                  0x1a75

        $sequence_3 = { 4c89442418 4c894c2420 4883ec28 b95772865c e8???????? 4c8bf8 b95772865c }
            // n = 7, score = 100
            //   4c89442418           | dec                 eax
            //   4c894c2420           | and                 dword ptr [ecx + 0x38], 0
            //   4883ec28             | mov                 dword ptr [ecx + 0x18], 0x201
            //   b95772865c           | dec                 eax
            //   e8????????           |                     
            //   4c8bf8               | mov                 dword ptr [ecx + 0x20], 6
            //   b95772865c           | dec                 eax

        $sequence_4 = { 84c0 0f85a6000000 488d5770 488d8d10010000 e8???????? 84c0 0f8588000000 }
            // n = 7, score = 100
            //   84c0                 | lea                 ecx, [ebp - 0x48]
            //   0f85a6000000         | dec                 esp
            //   488d5770             | lea                 eax, [0x3b6]
            //   488d8d10010000       | xor                 edx, edx
            //   e8????????           |                     
            //   84c0                 | xor                 ecx, ecx
            //   0f8588000000         | dec                 esp

        $sequence_5 = { 80e107 c0e103 498bc5 48d3e8 43300408 49ffc0 4983f803 }
            // n = 7, score = 100
            //   80e107               | jmp                 0x4f1
            //   c0e103               | dec                 eax
            //   498bc5               | mov                 edx, edi
            //   48d3e8               | dec                 ebx
            //   43300408             | lea                 ebx, [esp + esi]
            //   49ffc0               | dec                 eax
            //   4983f803             | cmp                 ebp, 0x10

        $sequence_6 = { c3 488d0d7ad90500 e8???????? 833d????????ff 75d2 66c705????????1301 }
            // n = 6, score = 100
            //   c3                   | lea                 ebx, [esp + 0x1410]
            //   488d0d7ad90500       | dec                 ecx
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   75d2                 | mov                 ebx, dword ptr [ebx + 0x30]
            //   66c705????????1301     |     

        $sequence_7 = { 498d8fc0000000 498bd1 e8???????? 90 488b55d7 4883fa10 720c }
            // n = 7, score = 100
            //   498d8fc0000000       | inc                 ebp
            //   498bd1               | xor                 edi, edi
            //   e8????????           |                     
            //   90                   | inc                 esp
            //   488b55d7             | cmp                 byte ptr [edi + 0x19], bh
            //   4883fa10             | jne                 0x1d10
            //   720c                 | dec                 eax

        $sequence_8 = { 80e107 c0e103 48b8fff3a94f9f372b79 48d3e8 42300402 48ffc2 4883fa07 }
            // n = 7, score = 100
            //   80e107               | inc                 ebx
            //   c0e103               | mov                 dword ptr [ebp - 0x65], ebx
            //   48b8fff3a94f9f372b79     | inc    edx
            //   48d3e8               | mov                 byte ptr [ecx + esi*8 + 0x3e], al
            //   42300402             | dec                 ebx
            //   48ffc2               | mov                 eax, dword ptr [eax + 0x70600]
            //   4883fa07             | inc                 edx

        $sequence_9 = { 418ac9 80e107 c0e103 49b81bf1eb35955fe34f 49d3e8 45300401 49ffc1 }
            // n = 7, score = 100
            //   418ac9               | dec                 ecx
            //   80e107               | cmp                 dword ptr [eax + 0x58], 0x10
            //   c0e103               | jb                  0x1cc4
            //   49b81bf1eb35955fe34f     | dec    ecx
            //   49d3e8               | mov                 edx, dword ptr [eax + 0x40]
            //   45300401             | dec                 esp
            //   49ffc1               | mov                 eax, dword ptr [esp + 0x40]

    condition:
        7 of them and filesize < 971776
}