rule win_r77_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.r77."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.r77"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740c 8b4f0c e8???????? 85c0 }
            // n = 4, score = 200
            //   740c                 | je                  0xe
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { 740b 8b0f e8???????? 85c0 }
            // n = 4, score = 200
            //   740b                 | je                  0xd
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { bafeff0000 6623c2 6683f806 721a 41b803000000 }
            // n = 5, score = 100
            //   bafeff0000           | test                ebx, ebx
            //   6623c2               | je                  0x38
            //   6683f806             | dec                 eax
            //   721a                 | test                ecx, ecx
            //   41b803000000         | je                  0x17

        $sequence_3 = { c1e202 8b4508 0fb60c10 83f91f 757d }
            // n = 5, score = 100
            //   c1e202               | shl                 edx, 2
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb60c10             | movzx               ecx, byte ptr [eax + edx]
            //   83f91f               | cmp                 ecx, 0x1f
            //   757d                 | jne                 0x7f

        $sequence_4 = { 0f8595010000 c745e4f8630110 e9???????? 894de0 c745e4f8630110 e9???????? }
            // n = 6, score = 100
            //   0f8595010000         | jne                 0x19b
            //   c745e4f8630110       | mov                 dword ptr [ebp - 0x1c], 0x100163f8
            //   e9????????           |                     
            //   894de0               | mov                 dword ptr [ebp - 0x20], ecx
            //   c745e4f8630110       | mov                 dword ptr [ebp - 0x1c], 0x100163f8
            //   e9????????           |                     

        $sequence_5 = { ba01000000 c1e200 8b4508 0fb60c10 81f990000000 750a }
            // n = 6, score = 100
            //   ba01000000           | mov                 edx, 1
            //   c1e200               | shl                 edx, 0
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0fb60c10             | movzx               ecx, byte ptr [eax + edx]
            //   81f990000000         | cmp                 ecx, 0x90
            //   750a                 | jne                 0xc

        $sequence_6 = { c745fc???????? eb07 c745fc???????? 8b4dfc 894df8 8b5510 }
            // n = 6, score = 100
            //   c745fc????????       |                     
            //   eb07                 | jmp                 9
            //   c745fc????????       |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_7 = { 83e03f c1eb06 6bf838 8b049df8a00110 f644072801 7444 837c0718ff }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1eb06               | shr                 ebx, 6
            //   6bf838               | imul                edi, eax, 0x38
            //   8b049df8a00110       | mov                 eax, dword ptr [ebx*4 + 0x1001a0f8]
            //   f644072801           | test                byte ptr [edi + eax + 0x28], 1
            //   7444                 | je                  0x46
            //   837c0718ff           | cmp                 dword ptr [edi + eax + 0x18], -1

        $sequence_8 = { b801000000 d1e0 8b4d08 0fb61401 85d2 750a }
            // n = 6, score = 100
            //   b801000000           | mov                 eax, 1
            //   d1e0                 | shl                 eax, 1
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb61401             | movzx               edx, byte ptr [ecx + eax]
            //   85d2                 | test                edx, edx
            //   750a                 | jne                 0xc

        $sequence_9 = { 488d157ad40000 e8???????? 8bcb 4885c0 740c 4883c420 }
            // n = 6, score = 100
            //   488d157ad40000       | and                 ax, dx
            //   e8????????           |                     
            //   8bcb                 | cmp                 ax, 6
            //   4885c0               | jb                  0x23
            //   740c                 | inc                 ecx
            //   4883c420             | mov                 eax, 3

        $sequence_10 = { ff15???????? 4889442450 488bd8 48897c2458 8d7d01 4885f6 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   4889442450           | dec                 eax
            //   488bd8               | mov                 ecx, dword ptr [ecx + 0x10]
            //   48897c2458           | dec                 eax
            //   8d7d01               | mov                 edx, ebx
            //   4885f6               | mov                 edx, 0xfffe

        $sequence_11 = { c3 4883ec38 488d05f5d50100 4889442428 488b05???????? 4889442420 48837c242000 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   4883ec38             | mov                 dword ptr [esp + 0x50], eax
            //   488d05f5d50100       | dec                 eax
            //   4889442428           | mov                 ebx, eax
            //   488b05????????       |                     
            //   4889442420           | dec                 eax
            //   48837c242000         | mov                 dword ptr [esp + 0x58], edi

        $sequence_12 = { 488b4c2440 e8???????? eb55 4c8b4c2458 4c8b442450 488d15f3010200 488b4c2440 }
            // n = 7, score = 100
            //   488b4c2440           | dec                 eax
            //   e8????????           |                     
            //   eb55                 | mov                 ecx, dword ptr [esp + 0x40]
            //   4c8b4c2458           | jmp                 0x57
            //   4c8b442450           | dec                 esp
            //   488d15f3010200       | mov                 ecx, dword ptr [esp + 0x58]
            //   488b4c2440           | dec                 esp

        $sequence_13 = { 4885db 7436 488b0d???????? 4885c9 7410 488b4910 488bd3 }
            // n = 7, score = 100
            //   4885db               | mov                 eax, dword ptr [esp + 0x50]
            //   7436                 | dec                 eax
            //   488b0d????????       |                     
            //   4885c9               | lea                 edx, [0x201f3]
            //   7410                 | dec                 eax
            //   488b4910             | mov                 ecx, dword ptr [esp + 0x40]
            //   488bd3               | dec                 eax

    condition:
        7 of them and filesize < 350208
}