rule win_racket_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.racket."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.racket"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837e2400 750a c6460c00 8b35???????? 68???????? 57 ffd3 }
            // n = 7, score = 100
            //   837e2400             | cmp                 dword ptr [esi + 0x24], 0
            //   750a                 | jne                 0xc
            //   c6460c00             | mov                 byte ptr [esi + 0xc], 0
            //   8b35????????         |                     
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd3                 | call                ebx

        $sequence_1 = { c1e803 2401 837b0400 884303 751b 6a00 6a00 }
            // n = 7, score = 100
            //   c1e803               | shr                 eax, 3
            //   2401                 | and                 al, 1
            //   837b0400             | cmp                 dword ptr [ebx + 4], 0
            //   884303               | mov                 byte ptr [ebx + 3], al
            //   751b                 | jne                 0x1d
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_2 = { 6a00 c706???????? 897e08 6a00 c7460c00000000 c7461000000000 6861080000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   c706????????         |                     
            //   897e08               | mov                 dword ptr [esi + 8], edi
            //   6a00                 | push                0
            //   c7460c00000000       | mov                 dword ptr [esi + 0xc], 0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   6861080000           | push                0x861

        $sequence_3 = { 8945f0 56 50 8d45f4 64a300000000 8b4510 85c0 }
            // n = 7, score = 100
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   56                   | push                esi
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax

        $sequence_4 = { 8987e4fdffff 8b86e0fdffff 8987e8fdffff 8b86e4fdffff 8987ecfdffff 8b86e8fdffff 8987f0fdffff }
            // n = 7, score = 100
            //   8987e4fdffff         | mov                 dword ptr [edi - 0x21c], eax
            //   8b86e0fdffff         | mov                 eax, dword ptr [esi - 0x220]
            //   8987e8fdffff         | mov                 dword ptr [edi - 0x218], eax
            //   8b86e4fdffff         | mov                 eax, dword ptr [esi - 0x21c]
            //   8987ecfdffff         | mov                 dword ptr [edi - 0x214], eax
            //   8b86e8fdffff         | mov                 eax, dword ptr [esi - 0x218]
            //   8987f0fdffff         | mov                 dword ptr [edi - 0x210], eax

        $sequence_5 = { 57 53 56 8d4a1c e8???????? 5f 5b }
            // n = 7, score = 100
            //   57                   | push                edi
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8d4a1c               | lea                 ecx, [edx + 0x1c]
            //   e8????????           |                     
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_6 = { 895dd0 8b7508 33ff 897dcc 8975bc 3b750c 0f8ddd070000 }
            // n = 7, score = 100
            //   895dd0               | mov                 dword ptr [ebp - 0x30], ebx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33ff                 | xor                 edi, edi
            //   897dcc               | mov                 dword ptr [ebp - 0x34], edi
            //   8975bc               | mov                 dword ptr [ebp - 0x44], esi
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]
            //   0f8ddd070000         | jge                 0x7e3

        $sequence_7 = { 894dfc 394db8 0f8c37050000 8b5514 be01000000 2bd0 894df4 }
            // n = 7, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   394db8               | cmp                 dword ptr [ebp - 0x48], ecx
            //   0f8c37050000         | jl                  0x53d
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   be01000000           | mov                 esi, 1
            //   2bd0                 | sub                 edx, eax
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_8 = { f7c700000002 7446 8b0a 3b4a04 752a 837a1000 7517 }
            // n = 7, score = 100
            //   f7c700000002         | test                edi, 0x2000000
            //   7446                 | je                  0x48
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   3b4a04               | cmp                 ecx, dword ptr [edx + 4]
            //   752a                 | jne                 0x2c
            //   837a1000             | cmp                 dword ptr [edx + 0x10], 0
            //   7517                 | jne                 0x19

        $sequence_9 = { ffb548ffffff 0f57c0 c745ac00000000 8d4da4 660fd645a4 e8???????? }
            // n = 6, score = 100
            //   ffb548ffffff         | push                dword ptr [ebp - 0xb8]
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745ac00000000       | mov                 dword ptr [ebp - 0x54], 0
            //   8d4da4               | lea                 ecx, [ebp - 0x5c]
            //   660fd645a4           | movq                qword ptr [ebp - 0x5c], xmm0
            //   e8????????           |                     

    condition:
        7 of them and filesize < 985088
}