rule win_ragnarlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ragnarlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ragnarlocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7da4 0facd106 33fe c1ea06 33d9 8b4da8 33fa }
            // n = 7, score = 300
            //   8b7da4               | mov                 edi, dword ptr [ebp - 0x5c]
            //   0facd106             | shrd                ecx, edx, 6
            //   33fe                 | xor                 edi, esi
            //   c1ea06               | shr                 edx, 6
            //   33d9                 | xor                 ebx, ecx
            //   8b4da8               | mov                 ecx, dword ptr [ebp - 0x58]
            //   33fa                 | xor                 edi, edx

        $sequence_1 = { c1e017 0bd8 8b45cc 0bf9 8b4dd4 33d2 }
            // n = 6, score = 300
            //   c1e017               | shl                 eax, 0x17
            //   0bd8                 | or                  ebx, eax
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   0bf9                 | or                  edi, ecx
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   33d2                 | xor                 edx, edx

        $sequence_2 = { 33d0 03de 8b4dfc 8b75f8 8bc6 13fa c745bc00000000 }
            // n = 7, score = 300
            //   33d0                 | xor                 edx, eax
            //   03de                 | add                 ebx, esi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   8bc6                 | mov                 eax, esi
            //   13fa                 | adc                 edi, edx
            //   c745bc00000000       | mov                 dword ptr [ebp - 0x44], 0

        $sequence_3 = { 8bf1 0facd113 c1e60d c1ea13 0bf2 895da8 8b957cffffff }
            // n = 7, score = 300
            //   8bf1                 | mov                 esi, ecx
            //   0facd113             | shrd                ecx, edx, 0x13
            //   c1e60d               | shl                 esi, 0xd
            //   c1ea13               | shr                 edx, 0x13
            //   0bf2                 | or                  esi, edx
            //   895da8               | mov                 dword ptr [ebp - 0x58], ebx
            //   8b957cffffff         | mov                 edx, dword ptr [ebp - 0x84]

        $sequence_4 = { 33db 0bd9 8975a4 8b8d50ffffff 8bfa 0fa4ca03 c1ef1d }
            // n = 7, score = 300
            //   33db                 | xor                 ebx, ebx
            //   0bd9                 | or                  ebx, ecx
            //   8975a4               | mov                 dword ptr [ebp - 0x5c], esi
            //   8b8d50ffffff         | mov                 ecx, dword ptr [ebp - 0xb0]
            //   8bfa                 | mov                 edi, edx
            //   0fa4ca03             | shld                edx, ecx, 3
            //   c1ef1d               | shr                 edi, 0x1d

        $sequence_5 = { 56 8b75f8 56 6a03 6a3b 57 ff15???????? }
            // n = 7, score = 300
            //   56                   | push                esi
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   56                   | push                esi
            //   6a03                 | push                3
            //   6a3b                 | push                0x3b
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_6 = { 8945e0 8b4594 8945e4 8b4590 8945e8 8b458c 8945c0 }
            // n = 7, score = 300
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4594               | mov                 eax, dword ptr [ebp - 0x6c]
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8b458c               | mov                 eax, dword ptr [ebp - 0x74]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax

        $sequence_7 = { 99 0bf2 c1e308 0bd8 0fb64143 0fa4de08 }
            // n = 6, score = 300
            //   99                   | cdq                 
            //   0bf2                 | or                  esi, edx
            //   c1e308               | shl                 ebx, 8
            //   0bd8                 | or                  ebx, eax
            //   0fb64143             | movzx               eax, byte ptr [ecx + 0x43]
            //   0fa4de08             | shld                esi, ebx, 8

        $sequence_8 = { 0bd8 0fb6410f 0fa4de08 8b4d98 99 0bf2 c1e308 }
            // n = 7, score = 300
            //   0bd8                 | or                  ebx, eax
            //   0fb6410f             | movzx               eax, byte ptr [ecx + 0xf]
            //   0fa4de08             | shld                esi, ebx, 8
            //   8b4d98               | mov                 ecx, dword ptr [ebp - 0x68]
            //   99                   | cdq                 
            //   0bf2                 | or                  esi, edx
            //   c1e308               | shl                 ebx, 8

        $sequence_9 = { c1ea0e 3175fc 0bfa 8b75dc 33df 8b7de0 f7d6 }
            // n = 7, score = 300
            //   c1ea0e               | shr                 edx, 0xe
            //   3175fc               | xor                 dword ptr [ebp - 4], esi
            //   0bfa                 | or                  edi, edx
            //   8b75dc               | mov                 esi, dword ptr [ebp - 0x24]
            //   33df                 | xor                 ebx, edi
            //   8b7de0               | mov                 edi, dword ptr [ebp - 0x20]
            //   f7d6                 | not                 esi

    condition:
        7 of them and filesize < 147456
}