rule win_railsetter_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.railsetter."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.railsetter"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d4d20 ff15???????? 90 488d8dd0010000 e9???????? }
            // n = 5, score = 100
            //   488d4d20             | dec                 eax
            //   ff15????????         |                     
            //   90                   | lea                 edx, [0x4bf86]
            //   488d8dd0010000       | dec                 eax
            //   e9????????           |                     

        $sequence_1 = { 488d0ddc760400 eb07 488d0deb760400 ba11000000 }
            // n = 4, score = 100
            //   488d0ddc760400       | dec                 eax
            //   eb07                 | mov                 ecx, eax
            //   488d0deb760400       | dec                 eax
            //   ba11000000           | lea                 edx, [ebp + 0xc8]

        $sequence_2 = { 488d8d10010000 ff15???????? 85c0 741a ff15???????? 8bc8 2b8d14010000 }
            // n = 7, score = 100
            //   488d8d10010000       | mov                 ebx, 0x26
            //   ff15????????         |                     
            //   85c0                 | inc                 ecx
            //   741a                 | cmp                 edi, 0x73
            //   ff15????????         |                     
            //   8bc8                 | jae                 0x11d
            //   2b8d14010000         | inc                 ecx

        $sequence_3 = { 428a8c09687e0400 482bd0 8b42fc d3e8 49895008 41894018 0fb60a }
            // n = 7, score = 100
            //   428a8c09687e0400     | mov                 ecx, eax
            //   482bd0               | dec                 eax
            //   8b42fc               | lea                 edx, [0x4a7fe]
            //   d3e8                 | dec                 eax
            //   49895008             | mov                 ecx, eax
            //   41894018             | mov                 edx, dword ptr [ebp + 0x5c]
            //   0fb60a               | dec                 eax

        $sequence_4 = { 488d0d36a00500 e8???????? 488bc8 0fb754246e e8???????? 488bc8 e8???????? }
            // n = 7, score = 100
            //   488d0d36a00500       | cvtps2pd            xmm2, xmm1
            //   e8????????           |                     
            //   488bc8               | dec                 cx
            //   0fb754246e           | movd                eax, mm2
            //   e8????????           |                     
            //   488bc8               | movaps              xmm0, xmm1
            //   e8????????           |                     

        $sequence_5 = { 448d4205 488d0d4dae0400 e8???????? 0f57c0 0f1185c8000000 498bcc 49837c241810 }
            // n = 7, score = 100
            //   448d4205             | mov                 edx, ebx
            //   488d0d4dae0400       | dec                 eax
            //   e8????????           |                     
            //   0f57c0               | mov                 ecx, eax
            //   0f1185c8000000       | dec                 eax
            //   498bcc               | lea                 edx, [0x518d8]
            //   49837c241810         | dec                 eax

        $sequence_6 = { 488d05c3ef0200 488903 eb02 33db 48891f }
            // n = 5, score = 100
            //   488d05c3ef0200       | mov                 dword ptr [edi + 8], esi
            //   488903               | dec                 eax
            //   eb02                 | lea                 eax, [0x445c3]
            //   33db                 | dec                 eax
            //   48891f               | mov                 dword ptr [edi], eax

        $sequence_7 = { 488d0d00690400 e8???????? ba19000000 448bca 448d4205 488d0d18640400 }
            // n = 6, score = 100
            //   488d0d00690400       | mov                 ecx, esi
            //   e8????????           |                     
            //   ba19000000           | test                eax, eax
            //   448bca               | je                  0x495
            //   448d4205             | dec                 eax
            //   488d0d18640400       | lea                 edx, [0x4ac33]

        $sequence_8 = { 483bc1 0f8291010000 4c8d4d0f 48837d2710 4c0f434d0f }
            // n = 5, score = 100
            //   483bc1               | dec                 ecx
            //   0f8291010000         | mov                 eax, edi
            //   4c8d4d0f             | dec                 eax
            //   48837d2710           | mov                 ecx, dword ptr [ebp + 0x160]
            //   4c0f434d0f           | dec                 eax

        $sequence_9 = { 48894a10 880a 488d153f360500 448d4115 488bcb e8???????? 488bc3 }
            // n = 7, score = 100
            //   48894a10             | dec                 eax
            //   880a                 | lea                 edx, [0x4ff95]
            //   488d153f360500       | dec                 eax
            //   448d4115             | mov                 ecx, eax
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   488bc3               | mov                 ecx, eax

    condition:
        7 of them and filesize < 866304
}