rule win_rambo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rambo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rambo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85f8faffff 6a01 50 ff15???????? 80a43df8faffff00 56 }
            // n = 6, score = 200
            //   8d85f8faffff         | lea                 eax, [ebp - 0x508]
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff15????????         |                     
            //   80a43df8faffff00     | and                 byte ptr [ebp + edi - 0x508], 0
            //   56                   | push                esi

        $sequence_1 = { 8065fe00 8d45fc 50 8d85f8feffff 50 c645fc72 }
            // n = 6, score = 200
            //   8065fe00             | and                 byte ptr [ebp - 2], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   c645fc72             | mov                 byte ptr [ebp - 4], 0x72

        $sequence_2 = { ff15???????? 83c428 6a32 ff15???????? 8d85f8faffff 50 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   83c428               | add                 esp, 0x28
            //   6a32                 | push                0x32
            //   ff15????????         |                     
            //   8d85f8faffff         | lea                 eax, [ebp - 0x508]
            //   50                   | push                eax

        $sequence_3 = { 83c410 85f6 745e 57 6a02 }
            // n = 5, score = 200
            //   83c410               | add                 esp, 0x10
            //   85f6                 | test                esi, esi
            //   745e                 | je                  0x60
            //   57                   | push                edi
            //   6a02                 | push                2

        $sequence_4 = { 8d85ecfdffff 50 8d85f0feffff 50 ff15???????? 83c41c }
            // n = 6, score = 200
            //   8d85ecfdffff         | lea                 eax, [ebp - 0x214]
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c41c               | add                 esp, 0x1c

        $sequence_5 = { 50 68???????? e8???????? 59 59 6a01 58 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   6a01                 | push                1
            //   58                   | pop                 eax

        $sequence_6 = { 81ec14020000 8d85f0feffff 56 50 6804010000 }
            // n = 5, score = 200
            //   81ec14020000         | sub                 esp, 0x214
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   56                   | push                esi
            //   50                   | push                eax
            //   6804010000           | push                0x104

        $sequence_7 = { 59 8d85fcfeffff 59 50 ff15???????? 33c0 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 0f85ba000000 8d4c241c c68424000400000f e8???????? 8d8c249c000000 c68424000400000b e8???????? }
            // n = 7, score = 100
            //   0f85ba000000         | jne                 0xc0
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   c68424000400000f     | mov                 byte ptr [esp + 0x400], 0xf
            //   e8????????           |                     
            //   8d8c249c000000       | lea                 ecx, [esp + 0x9c]
            //   c68424000400000b     | mov                 byte ptr [esp + 0x400], 0xb
            //   e8????????           |                     

        $sequence_9 = { 33c0 50 8d4c241c c684240404000002 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   c684240404000002     | mov                 byte ptr [esp + 0x404], 2

        $sequence_10 = { 03dd 33c3 8d1c31 33c3 81c14786c861 2bf8 4a }
            // n = 7, score = 100
            //   03dd                 | add                 ebx, ebp
            //   33c3                 | xor                 eax, ebx
            //   8d1c31               | lea                 ebx, [ecx + esi]
            //   33c3                 | xor                 eax, ebx
            //   81c14786c861         | add                 ecx, 0x61c88647
            //   2bf8                 | sub                 edi, eax
            //   4a                   | dec                 edx

        $sequence_11 = { 57 b940000000 8d7c240d 8844240c f3ab 66ab }
            // n = 6, score = 100
            //   57                   | push                edi
            //   b940000000           | mov                 ecx, 0x40
            //   8d7c240d             | lea                 edi, [esp + 0xd]
            //   8844240c             | mov                 byte ptr [esp + 0xc], al
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_12 = { 56 56 8d4c2424 e8???????? 50 8d4c246c e8???????? }
            // n = 7, score = 100
            //   56                   | push                esi
            //   56                   | push                esi
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4c246c             | lea                 ecx, [esp + 0x6c]
            //   e8????????           |                     

        $sequence_13 = { c684240004000001 e8???????? c684240004000000 8d4c2464 e8???????? 8d4c242c c7842400040000ffffffff }
            // n = 7, score = 100
            //   c684240004000001     | mov                 byte ptr [esp + 0x400], 1
            //   e8????????           |                     
            //   c684240004000000     | mov                 byte ptr [esp + 0x400], 0
            //   8d4c2464             | lea                 ecx, [esp + 0x64]
            //   e8????????           |                     
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   c7842400040000ffffffff     | mov    dword ptr [esp + 0x400], 0xffffffff

        $sequence_14 = { 33ed 6804010000 6804010000 8d4c2434 89ac2408040000 e8???????? }
            // n = 6, score = 100
            //   33ed                 | xor                 ebp, ebp
            //   6804010000           | push                0x104
            //   6804010000           | push                0x104
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   89ac2408040000       | mov                 dword ptr [esp + 0x408], ebp
            //   e8????????           |                     

        $sequence_15 = { 8d4c2414 6a20 51 8d4c2424 e8???????? 50 8d4c242c }
            // n = 7, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   6a20                 | push                0x20
            //   51                   | push                ecx
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   e8????????           |                     
            //   50                   | push                eax
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]

    condition:
        7 of them and filesize < 57344
}