rule win_ramnit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ramnit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramnit"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7d08 b000 f2ae 8bc1 }
            // n = 4, score = 4000
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   b000                 | mov                 al, 0
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8bc1                 | mov                 eax, ecx

        $sequence_1 = { 5f 59 5a 5b c9 c20800 55 }
            // n = 7, score = 4000
            //   5f                   | pop                 edi
            //   59                   | pop                 ecx
            //   5a                   | pop                 edx
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   55                   | push                ebp

        $sequence_2 = { fd 8b4d10 8b7d0c 8b7508 f3a4 }
            // n = 5, score = 4000
            //   fd                   | std                 
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_3 = { 3a4510 7407 b800000000 eb02 8bc7 5a }
            // n = 6, score = 4000
            //   3a4510               | cmp                 al, byte ptr [ebp + 0x10]
            //   7407                 | je                  9
            //   b800000000           | mov                 eax, 0
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   5a                   | pop                 edx

        $sequence_4 = { ba00000000 59 5f 5e 5b c9 }
            // n = 6, score = 4000
            //   ba00000000           | mov                 edx, 0
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_5 = { ff7514 ff7510 e8???????? 83f800 750b 4f 3b7d08 }
            // n = 7, score = 4000
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   83f800               | cmp                 eax, 0
            //   750b                 | jne                 0xd
            //   4f                   | dec                 edi
            //   3b7d08               | cmp                 edi, dword ptr [ebp + 8]

        $sequence_6 = { fc 8b4d0c 8b7d08 b000 f3aa }
            // n = 5, score = 4000
            //   fc                   | cld                 
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   b000                 | mov                 al, 0
            //   f3aa                 | rep stosb           byte ptr es:[edi], al

        $sequence_7 = { 52 8b4508 8b5d0c 4b 23d8 83fb00 740e }
            // n = 7, score = 4000
            //   52                   | push                edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   4b                   | dec                 ebx
            //   23d8                 | and                 ebx, eax
            //   83fb00               | cmp                 ebx, 0
            //   740e                 | je                  0x10

        $sequence_8 = { 8bf8 037d14 3b7df8 771f 8945fc ff7514 ff7510 }
            // n = 7, score = 4000
            //   8bf8                 | mov                 edi, eax
            //   037d14               | add                 edi, dword ptr [ebp + 0x14]
            //   3b7df8               | cmp                 edi, dword ptr [ebp - 8]
            //   771f                 | ja                  0x21
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_9 = { 8bec 83c4f8 56 57 51 53 52 }
            // n = 7, score = 4000
            //   8bec                 | mov                 ebp, esp
            //   83c4f8               | add                 esp, -8
            //   56                   | push                esi
            //   57                   | push                edi
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   52                   | push                edx

    condition:
        7 of them and filesize < 470016
}