rule win_ramsay_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ramsay."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ramsay"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7514 ff15???????? 83f820 7502 eb07 }
            // n = 5, score = 600
            //   7514                 | jne                 0x16
            //   ff15????????         |                     
            //   83f820               | cmp                 eax, 0x20
            //   7502                 | jne                 4
            //   eb07                 | jmp                 9

        $sequence_1 = { ff15???????? 85c0 7502 eb02 ebb1 }
            // n = 5, score = 600
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb02                 | jmp                 4
            //   ebb1                 | jmp                 0xffffffb3

        $sequence_2 = { 85c0 744c c745e800000000 eb09 8b45e8 83c001 }
            // n = 6, score = 500
            //   85c0                 | test                eax, eax
            //   744c                 | je                  0x4e
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   eb09                 | jmp                 0xb
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83c001               | add                 eax, 1

        $sequence_3 = { 8b4d08 83c101 51 6a00 8b55f8 }
            // n = 5, score = 500
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   83c101               | add                 ecx, 1
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_4 = { 85c0 751a 8b4df8 51 ff15???????? 8b55fc }
            // n = 6, score = 500
            //   85c0                 | test                eax, eax
            //   751a                 | jne                 0x1c
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_5 = { 8b5508 8b4508 8a481c 884a0b 8b5508 8b4508 }
            // n = 6, score = 500
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8a481c               | mov                 cl, byte ptr [eax + 0x1c]
            //   884a0b               | mov                 byte ptr [edx + 0xb], cl
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { 837de806 7d34 8b4d08 034de8 0fbe4101 }
            // n = 5, score = 500
            //   837de806             | cmp                 dword ptr [ebp - 0x18], 6
            //   7d34                 | jge                 0x36
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   034de8               | add                 ecx, dword ptr [ebp - 0x18]
            //   0fbe4101             | movsx               eax, byte ptr [ecx + 1]

        $sequence_7 = { 884a01 ebbd b801000000 8b4df8 33cd e8???????? }
            // n = 6, score = 500
            //   884a01               | mov                 byte ptr [edx + 1], cl
            //   ebbd                 | jmp                 0xffffffbf
            //   b801000000           | mov                 eax, 1
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     

        $sequence_8 = { e8???????? 83c404 8945f8 8b45f8 8945fc 8b4d0c }
            // n = 6, score = 500
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

        $sequence_9 = { 8955e8 eba5 8b45f4 8be5 }
            // n = 4, score = 500
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   eba5                 | jmp                 0xffffffa7
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8be5                 | mov                 esp, ebp

        $sequence_10 = { ff15???????? 33c0 e9???????? e8???????? 85c0 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_11 = { 488d8c24ec040000 ff15???????? 4885c0 7415 488b8c2420090000 }
            // n = 5, score = 200
            //   488d8c24ec040000     | dec                 eax
            //   ff15????????         |                     
            //   4885c0               | lea                 ecx, [esp + 0x4ec]
            //   7415                 | dec                 eax
            //   488b8c2420090000     | test                eax, eax

        $sequence_12 = { 488d8c24f0020000 e8???????? 4889842420050000 8b842420050000 }
            // n = 4, score = 200
            //   488d8c24f0020000     | dec                 eax
            //   e8????????           |                     
            //   4889842420050000     | cwde                
            //   8b842420050000       | dec                 eax

        $sequence_13 = { 488d8c24f0010000 ff15???????? 488d8c24f0010000 ff15???????? }
            // n = 4, score = 200
            //   488d8c24f0010000     | je                  0x1f
            //   ff15????????         |                     
            //   488d8c24f0010000     | dec                 eax
            //   ff15????????         |                     

        $sequence_14 = { 488d8c24ec040000 ff15???????? 85c0 7402 }
            // n = 4, score = 200
            //   488d8c24ec040000     | mov                 ecx, dword ptr [esp + 0x920]
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7402                 | lea                 ecx, [esp + 0x4ec]

        $sequence_15 = { 488d8c24f0010000 ff15???????? 4898 488d84047e040000 }
            // n = 4, score = 200
            //   488d8c24f0010000     | lea                 ecx, [esp + 0x4ec]
            //   ff15????????         |                     
            //   4898                 | dec                 eax
            //   488d84047e040000     | lea                 ecx, [esp + 0x4ec]

    condition:
        7 of them and filesize < 2031616
}