rule win_ranbyus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ranbyus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ranbyus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 83c40c 33c0 eb03 83c8ff 5f }
            // n = 7, score = 1100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi

        $sequence_1 = { 59 85ff 743e 56 6a01 }
            // n = 5, score = 1100
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi
            //   743e                 | je                  0x40
            //   56                   | push                esi
            //   6a01                 | push                1

        $sequence_2 = { 83661800 33c0 5e c3 56 }
            // n = 5, score = 1100
            //   83661800             | and                 dword ptr [esi + 0x18], 0
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_3 = { 89460c 8b06 59 894604 }
            // n = 4, score = 1100
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   59                   | pop                 ecx
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_4 = { 55 8d6c2490 81ec28010000 56 }
            // n = 4, score = 1100
            //   55                   | push                ebp
            //   8d6c2490             | lea                 ebp, [esp - 0x70]
            //   81ec28010000         | sub                 esp, 0x128
            //   56                   | push                esi

        $sequence_5 = { 3b4c2404 7504 83601800 33c0 40 eb11 50 }
            // n = 7, score = 1100
            //   3b4c2404             | cmp                 ecx, dword ptr [esp + 4]
            //   7504                 | jne                 6
            //   83601800             | and                 dword ptr [eax + 0x18], 0
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   eb11                 | jmp                 0x13
            //   50                   | push                eax

        $sequence_6 = { 6801200000 e8???????? 8bf0 59 }
            // n = 4, score = 1100
            //   6801200000           | push                0x2001
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_7 = { 83c605 e9???????? 47 e9???????? 0fb64e01 }
            // n = 5, score = 1100
            //   83c605               | add                 esi, 5
            //   e9????????           |                     
            //   47                   | inc                 edi
            //   e9????????           |                     
            //   0fb64e01             | movzx               ecx, byte ptr [esi + 1]

        $sequence_8 = { e8???????? 85c0 7504 83c8ff c3 c7402401000000 33c0 }
            // n = 7, score = 1100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   83c8ff               | or                  eax, 0xffffffff
            //   c3                   | ret                 
            //   c7402401000000       | mov                 dword ptr [eax + 0x24], 1
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { c706???????? eb07 8bce e8???????? 837e0400 75f3 }
            // n = 6, score = 1100
            //   c706????????         |                     
            //   eb07                 | jmp                 9
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   837e0400             | cmp                 dword ptr [esi + 4], 0
            //   75f3                 | jne                 0xfffffff5

    condition:
        7 of them and filesize < 638976
}