rule win_ransoc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ransoc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransoc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 57 50 6a01 e8???????? }
            // n = 5, score = 300
            //   c3                   | ret                 
            //   57                   | push                edi
            //   50                   | push                eax
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_1 = { 8b5034 3bd7 753e 8b7230 }
            // n = 4, score = 300
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   3bd7                 | cmp                 edx, edi
            //   753e                 | jne                 0x40
            //   8b7230               | mov                 esi, dword ptr [edx + 0x30]

        $sequence_2 = { eb02 8913 894a34 895138 8b4834 8b503c }
            // n = 6, score = 300
            //   eb02                 | jmp                 4
            //   8913                 | mov                 dword ptr [ebx], edx
            //   894a34               | mov                 dword ptr [edx + 0x34], ecx
            //   895138               | mov                 dword ptr [ecx + 0x38], edx
            //   8b4834               | mov                 ecx, dword ptr [eax + 0x34]
            //   8b503c               | mov                 edx, dword ptr [eax + 0x3c]

        $sequence_3 = { 0f8487000000 56 68???????? 45 e8???????? 83c408 }
            // n = 6, score = 300
            //   0f8487000000         | je                  0x8d
            //   56                   | push                esi
            //   68????????           |                     
            //   45                   | inc                 ebp
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_4 = { 394134 7506 8b5034 895134 394140 7506 8b5034 }
            // n = 7, score = 300
            //   394134               | cmp                 dword ptr [ecx + 0x34], eax
            //   7506                 | jne                 8
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]
            //   895134               | mov                 dword ptr [ecx + 0x34], edx
            //   394140               | cmp                 dword ptr [ecx + 0x40], eax
            //   7506                 | jne                 8
            //   8b5034               | mov                 edx, dword ptr [eax + 0x34]

        $sequence_5 = { 8b542428 5d 894808 5b }
            // n = 4, score = 300
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   5d                   | pop                 ebp
            //   894808               | mov                 dword ptr [eax + 8], ecx
            //   5b                   | pop                 ebx

        $sequence_6 = { 89462c a820 7406 8b4604 014804 8b462c a900080000 }
            // n = 7, score = 300
            //   89462c               | mov                 dword ptr [esi + 0x2c], eax
            //   a820                 | test                al, 0x20
            //   7406                 | je                  8
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   014804               | add                 dword ptr [eax + 4], ecx
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]
            //   a900080000           | test                eax, 0x800

        $sequence_7 = { eb07 894a34 eb02 890b 894134 894838 8b13 }
            // n = 7, score = 300
            //   eb07                 | jmp                 9
            //   894a34               | mov                 dword ptr [edx + 0x34], ecx
            //   eb02                 | jmp                 4
            //   890b                 | mov                 dword ptr [ebx], ecx
            //   894134               | mov                 dword ptr [ecx + 0x34], eax
            //   894838               | mov                 dword ptr [eax + 0x38], ecx
            //   8b13                 | mov                 edx, dword ptr [ebx]

        $sequence_8 = { f7402c00000001 a1???????? 890c24 7505 }
            // n = 4, score = 300
            //   f7402c00000001       | test                dword ptr [eax + 0x2c], 0x1000000
            //   a1????????           |                     
            //   890c24               | mov                 dword ptr [esp], ecx
            //   7505                 | jne                 7

        $sequence_9 = { 83c618 56 e8???????? 83c40c 5e c3 }
            // n = 6, score = 300
            //   83c618               | add                 esi, 0x18
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   5e                   | pop                 esi
            //   c3                   | ret                 

    condition:
        7 of them and filesize < 958464
}