rule win_ransomlock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ransomlock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ransomlock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5120 56 50 ffd2 85c0 }
            // n = 5, score = 100
            //   8b5120               | mov                 edx, dword ptr [ecx + 0x20]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   85c0                 | test                eax, eax

        $sequence_1 = { 51 50 66894802 ff15???????? 53 8d9decfbffff }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   50                   | push                eax
            //   66894802             | mov                 word ptr [eax + 2], cx
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   8d9decfbffff         | lea                 ebx, [ebp - 0x414]

        $sequence_2 = { 8b5120 56 50 ffd2 85c0 7807 c745ec01000000 }
            // n = 7, score = 100
            //   8b5120               | mov                 edx, dword ptr [ecx + 0x20]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   85c0                 | test                eax, eax
            //   7807                 | js                  9
            //   c745ec01000000       | mov                 dword ptr [ebp - 0x14], 1

        $sequence_3 = { 83c0ec 52 50 8b01 ffd0 }
            // n = 5, score = 100
            //   83c0ec               | add                 eax, -0x14
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ffd0                 | call                eax

        $sequence_4 = { 8d45b8 50 ff15???????? 6804010000 68???????? ff15???????? e9???????? }
            // n = 7, score = 100
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6804010000           | push                0x104
            //   68????????           |                     
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_5 = { 53 53 6a01 68???????? ff15???????? 8bf0 85f6 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_6 = { 8be5 5d c3 83f801 7408 }
            // n = 5, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   83f801               | cmp                 eax, 1
            //   7408                 | je                  0xa

        $sequence_7 = { 8b7510 8bce ba???????? e8???????? 85c0 7414 8b5514 }
            // n = 7, score = 100
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   8bce                 | mov                 ecx, esi
            //   ba????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]

        $sequence_8 = { 8b5104 57 ffd2 5f 5e }
            // n = 5, score = 100
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   57                   | push                edi
            //   ffd2                 | call                edx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 8d95a0f9ffff 68???????? 52 ffd3 83c414 8dbdb0fdffff 32c0 }
            // n = 7, score = 100
            //   8d95a0f9ffff         | lea                 edx, [ebp - 0x660]
            //   68????????           |                     
            //   52                   | push                edx
            //   ffd3                 | call                ebx
            //   83c414               | add                 esp, 0x14
            //   8dbdb0fdffff         | lea                 edi, [ebp - 0x250]
            //   32c0                 | xor                 al, al

    condition:
        7 of them and filesize < 360448
}