rule win_rapid_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rapid_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rapid_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 6801000004 6800a40000 ff75f8 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   6801000004           | push                0x4000001
            //   6800a40000           | push                0xa400
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_1 = { eb05 803e00 7509 803a00 0f840c010000 }
            // n = 5, score = 200
            //   eb05                 | jmp                 7
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7509                 | jne                 0xb
            //   803a00               | cmp                 byte ptr [edx], 0
            //   0f840c010000         | je                  0x112

        $sequence_2 = { ff15???????? 8b4c2438 f6c110 7410 68???????? 56 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8b4c2438             | mov                 ecx, dword ptr [esp + 0x38]
            //   f6c110               | test                cl, 0x10
            //   7410                 | je                  0x12
            //   68????????           |                     
            //   56                   | push                esi

        $sequence_3 = { 6a00 6a07 6a00 ff75fc ffd7 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a07                 | push                7
            //   6a00                 | push                0
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd7                 | call                edi

        $sequence_4 = { 75f7 ff75fc 51 6801000040 ff750c 53 ff15???????? }
            // n = 7, score = 200
            //   75f7                 | jne                 0xfffffff9
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   6801000040           | push                0x40000001
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   53                   | push                ebx
            //   ff15????????         |                     

        $sequence_5 = { 84c0 0f94c1 33c0 84c9 5f 5e 0f94c0 }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   0f94c1               | sete                cl
            //   33c0                 | xor                 eax, eax
            //   84c9                 | test                cl, cl
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   0f94c0               | sete                al

        $sequence_6 = { ff15???????? 56 ffd7 8bd0 8bce e8???????? }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8bd0                 | mov                 edx, eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     

        $sequence_7 = { 80c261 8857ff 4b 75eb 8b75fc 5b }
            // n = 6, score = 200
            //   80c261               | add                 dl, 0x61
            //   8857ff               | mov                 byte ptr [edi - 1], dl
            //   4b                   | dec                 ebx
            //   75eb                 | jne                 0xffffffed
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   5b                   | pop                 ebx

        $sequence_8 = { a3???????? e8???????? 83c404 b001 5e }
            // n = 5, score = 100
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi

        $sequence_9 = { 6a02 6a00 6a03 68000000c0 8d85f8feffff 50 }
            // n = 6, score = 100
            //   6a02                 | push                2
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   68000000c0           | push                0xc0000000
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax

        $sequence_10 = { 56 ff15???????? 85c0 7448 8b3d???????? }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7448                 | je                  0x4a
            //   8b3d????????         |                     

        $sequence_11 = { 8d7601 80becc8c410000 75f4 e8???????? 99 8d4eff }
            // n = 6, score = 100
            //   8d7601               | lea                 esi, [esi + 1]
            //   80becc8c410000       | cmp                 byte ptr [esi + 0x418ccc], 0
            //   75f4                 | jne                 0xfffffff6
            //   e8????????           |                     
            //   99                   | cdq                 
            //   8d4eff               | lea                 ecx, [esi - 1]

        $sequence_12 = { 83ea01 75f2 8b7dac 8b55b4 33c0 c6043200 }
            // n = 6, score = 100
            //   83ea01               | sub                 edx, 1
            //   75f2                 | jne                 0xfffffff4
            //   8b7dac               | mov                 edi, dword ptr [ebp - 0x54]
            //   8b55b4               | mov                 edx, dword ptr [ebp - 0x4c]
            //   33c0                 | xor                 eax, eax
            //   c6043200             | mov                 byte ptr [edx + esi], 0

        $sequence_13 = { 8d7f08 8b048dc4724000 ffe0 f7c703000000 7413 }
            // n = 5, score = 100
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048dc4724000       | mov                 eax, dword ptr [ecx*4 + 0x4072c4]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3
            //   7413                 | je                  0x15

        $sequence_14 = { eb05 1bc0 83c801 8b4df0 85c0 0f84a0feffff }
            // n = 6, score = 100
            //   eb05                 | jmp                 7
            //   1bc0                 | sbb                 eax, eax
            //   83c801               | or                  eax, 1
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   85c0                 | test                eax, eax
            //   0f84a0feffff         | je                  0xfffffea6

    condition:
        7 of them and filesize < 286720
}