rule win_ratankbapos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ratankbapos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ratankbapos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c5 8945f8 56 8b7508 85f6 0f8413010000 }
            // n = 6, score = 300
            //   33c5                 | xor                 eax, ebp
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   85f6                 | test                esi, esi
            //   0f8413010000         | je                  0x119

        $sequence_1 = { ff15???????? 8bf0 8d4dcc 897304 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   897304               | mov                 dword ptr [ebx + 4], esi

        $sequence_2 = { 0fbec2 0fbe8040010110 83e00f eb02 33c0 0fbe84c160010110 }
            // n = 6, score = 300
            //   0fbec2               | movsx               eax, dl
            //   0fbe8040010110       | movsx               eax, byte ptr [eax + 0x10010140]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c160010110     | movsx               eax, byte ptr [ecx + eax*8 + 0x10010160]

        $sequence_3 = { c1f905 8b0c8de04d0110 83e01f c1e006 f644080401 }
            // n = 5, score = 300
            //   c1f905               | sar                 ecx, 5
            //   8b0c8de04d0110       | mov                 ecx, dword ptr [ecx*4 + 0x10014de0]
            //   83e01f               | and                 eax, 0x1f
            //   c1e006               | shl                 eax, 6
            //   f644080401           | test                byte ptr [eax + ecx + 4], 1

        $sequence_4 = { eb05 1bc0 83d8ff 85c0 7508 8d8646b10000 }
            // n = 6, score = 300
            //   eb05                 | jmp                 7
            //   1bc0                 | sbb                 eax, eax
            //   83d8ff               | sbb                 eax, -1
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   8d8646b10000         | lea                 eax, [esi + 0xb146]

        $sequence_5 = { 83e203 83f908 7229 f3a5 ff249590490010 }
            // n = 5, score = 300
            //   83e203               | and                 edx, 3
            //   83f908               | cmp                 ecx, 8
            //   7229                 | jb                  0x2b
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff249590490010       | jmp                 dword ptr [edx*4 + 0x10004990]

        $sequence_6 = { 40 3acb 75f9 2bc6 3bd0 72dc }
            // n = 6, score = 300
            //   40                   | inc                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi
            //   3bd0                 | cmp                 edx, eax
            //   72dc                 | jb                  0xffffffde

        $sequence_7 = { 8b5518 50 8b4514 51 8b4d08 52 50 }
            // n = 7, score = 300
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   50                   | push                eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_8 = { e8???????? 8b4da4 8945c8 c6040800 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   c6040800             | mov                 byte ptr [eax + ecx], 0

        $sequence_9 = { 0fbe8040010110 83e00f eb02 33c0 0fbe84c160010110 6a07 c1f804 }
            // n = 7, score = 300
            //   0fbe8040010110       | movsx               eax, byte ptr [eax + 0x10010140]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c160010110     | movsx               eax, byte ptr [ecx + eax*8 + 0x10010160]
            //   6a07                 | push                7
            //   c1f804               | sar                 eax, 4

    condition:
        7 of them and filesize < 327680
}