rule win_ratel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ratel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ratel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c705????????080e4c00 e8???????? 83ec08 b9???????? c705????????01000000 c705????????94154c00 c705????????00000000 }
            // n = 7, score = 100
            //   c705????????080e4c00     |     
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   b9????????           |                     
            //   c705????????01000000     |     
            //   c705????????94154c00     |     
            //   c705????????00000000     |     

        $sequence_1 = { 8b510c 31c0 395108 0f82dafeffff 8b01 ff5024 89c2 }
            // n = 7, score = 100
            //   8b510c               | mov                 edx, dword ptr [ecx + 0xc]
            //   31c0                 | xor                 eax, eax
            //   395108               | cmp                 dword ptr [ecx + 8], edx
            //   0f82dafeffff         | jb                  0xfffffee0
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5024               | call                dword ptr [eax + 0x24]
            //   89c2                 | mov                 edx, eax

        $sequence_2 = { 8b5c2420 395808 0f8c51020000 8b442454 8b4c2420 8b4004 39c8 }
            // n = 7, score = 100
            //   8b5c2420             | mov                 ebx, dword ptr [esp + 0x20]
            //   395808               | cmp                 dword ptr [eax + 8], ebx
            //   0f8c51020000         | jl                  0x257
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   39c8                 | cmp                 eax, ecx

        $sequence_3 = { 8b4508 8b550c 890c24 8d4de0 8945d0 8955d4 e8???????? }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   8d4de0               | lea                 ecx, [ebp - 0x20]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   8955d4               | mov                 dword ptr [ebp - 0x2c], edx
            //   e8????????           |                     

        $sequence_4 = { 8d5601 89d8 89530c e8???????? 89c1 890c24 e9???????? }
            // n = 7, score = 100
            //   8d5601               | lea                 edx, [esi + 1]
            //   89d8                 | mov                 eax, ebx
            //   89530c               | mov                 dword ptr [ebx + 0xc], edx
            //   e8????????           |                     
            //   89c1                 | mov                 ecx, eax
            //   890c24               | mov                 dword ptr [esp], ecx
            //   e9????????           |                     

        $sequence_5 = { 8d7810 83c004 c744243200000000 890424 89542426 31d2 6689542436 }
            // n = 7, score = 100
            //   8d7810               | lea                 edi, [eax + 0x10]
            //   83c004               | add                 eax, 4
            //   c744243200000000     | mov                 dword ptr [esp + 0x32], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   89542426             | mov                 dword ptr [esp + 0x26], edx
            //   31d2                 | xor                 edx, edx
            //   6689542436           | mov                 word ptr [esp + 0x36], dx

        $sequence_6 = { e9???????? 8b01 ff5024 89c3 83f8ff 0f8522fbffff c7450800000000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5024               | call                dword ptr [eax + 0x24]
            //   89c3                 | mov                 ebx, eax
            //   83f8ff               | cmp                 eax, -1
            //   0f8522fbffff         | jne                 0xfffffb28
            //   c7450800000000       | mov                 dword ptr [ebp + 8], 0

        $sequence_7 = { 8b470c 894c2410 8b00 890424 e8???????? 8b4c2410 85c0 }
            // n = 7, score = 100
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   894c2410             | mov                 dword ptr [esp + 0x10], ecx
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   85c0                 | test                eax, eax

        $sequence_8 = { e8???????? 50 891c24 e8???????? 85ff 7408 893c24 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   7408                 | je                  0xa
            //   893c24               | mov                 dword ptr [esp], edi

        $sequence_9 = { 894dcc 8d4de7 8945c4 668945d2 e8???????? 83ec08 807de700 }
            // n = 7, score = 100
            //   894dcc               | mov                 dword ptr [ebp - 0x34], ecx
            //   8d4de7               | lea                 ecx, [ebp - 0x19]
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   668945d2             | mov                 word ptr [ebp - 0x2e], ax
            //   e8????????           |                     
            //   83ec08               | sub                 esp, 8
            //   807de700             | cmp                 byte ptr [ebp - 0x19], 0

    condition:
        7 of them and filesize < 2174976
}