rule win_rawdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rawdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rawdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 030e 03d1 c1c207 4103d2 }
            // n = 4, score = 600
            //   030e                 | add                 edx, ecx
            //   03d1                 | inc                 ecx
            //   c1c207               | mov                 ecx, eax
            //   4103d2               | not                 ecx

        $sequence_1 = { 030b 4403d1 418bc8 f7d1 23ca }
            // n = 5, score = 600
            //   030b                 | add                 ecx, dword ptr [ebx]
            //   4403d1               | inc                 esp
            //   418bc8               | add                 edx, ecx
            //   f7d1                 | inc                 ecx
            //   23ca                 | mov                 ecx, eax

        $sequence_2 = { 034218 418d91051d8804 458d8a39d0d4d9 03d0 }
            // n = 4, score = 600
            //   034218               | inc                 ebp
            //   418d91051d8804       | lea                 eax, [ecx - 0x944b4a0]
            //   458d8a39d0d4d9       | add                 edx, eax
            //   03d0                 | inc                 ebp

        $sequence_3 = { 03442444 3d00040000 730e 488d4c2450 }
            // n = 4, score = 600
            //   03442444             | rol                 edx, 0xb
            //   3d00040000           | inc                 ecx
            //   730e                 | add                 edx, ebx
            //   488d4c2450           | add                 eax, dword ptr [edx + 0x18]

        $sequence_4 = { 034210 418d90a9cfde4b 458d81604bbbf6 03d0 }
            // n = 4, score = 600
            //   034210               | rol                 edx, 7
            //   418d90a9cfde4b       | inc                 ecx
            //   458d81604bbbf6       | add                 edx, edx
            //   03d0                 | and                 eax, edx

        $sequence_5 = { 034608 03d0 8b442408 4103c1 4c8b4c2410 }
            // n = 5, score = 600
            //   034608               | inc                 ebp
            //   03d0                 | lea                 ecx, [edx - 0x262b2fc7]
            //   8b442408             | add                 edx, eax
            //   4103c1               | dec                 eax
            //   4c8b4c2410           | mov                 eax, dword ptr [esp]

        $sequence_6 = { 034808 4403c1 8bcb f7d1 23ca }
            // n = 5, score = 600
            //   034808               | add                 eax, dword ptr [esp + 0x44]
            //   4403c1               | cmp                 eax, 0x400
            //   8bcb                 | jae                 0x15
            //   f7d1                 | dec                 eax
            //   23ca                 | lea                 ecx, [esp + 0x50]

        $sequence_7 = { 034824 418bc0 4403c9 33c2 418d8be599dbe6 }
            // n = 5, score = 600
            //   034824               | mov                 edx, ebx
            //   418bc0               | add                 eax, dword ptr [esp + 0x44]
            //   4403c9               | cmp                 eax, 0x400
            //   33c2                 | jae                 0x15
            //   418d8be599dbe6       | dec                 eax

        $sequence_8 = { 0101 0101 0100 0000 0001 }
            // n = 5, score = 400
            //   0101                 | mov                 ecx, ebx
            //   0101                 | not                 ecx
            //   0100                 | and                 ecx, edx
            //   0000                 | inc                 ecx
            //   0001                 | rol                 eax, 9

        $sequence_9 = { 0000 0001 0100 0001 0101 }
            // n = 5, score = 400
            //   0000                 | xor                 eax, edx
            //   0001                 | inc                 ecx
            //   0100                 | lea                 ecx, [ebx - 0x1924661b]
            //   0001                 | add                 ecx, dword ptr [eax + 0x24]
            //   0101                 | inc                 ecx

        $sequence_10 = { 8be5 5d c3 ff15???????? 83f8ff 746f 8d85bcf8ffff }
            // n = 7, score = 200
            //   8be5                 | inc                 ecx
            //   5d                   | add                 edx, edx
            //   c3                   | and                 eax, edx
            //   ff15????????         |                     
            //   83f8ff               | add                 ecx, dword ptr [esi]
            //   746f                 | add                 edx, ecx
            //   8d85bcf8ffff         | rol                 edx, 7

        $sequence_11 = { 0f8405010000 83e809 7415 83e803 0f8538010000 c745dc44690210 e9???????? }
            // n = 7, score = 200
            //   0f8405010000         | rol                 edx, 7
            //   83e809               | inc                 ecx
            //   7415                 | add                 edx, edx
            //   83e803               | add                 ecx, dword ptr [esi]
            //   0f8538010000         | add                 edx, ecx
            //   c745dc44690210       | rol                 edx, 7
            //   e9????????           |                     

        $sequence_12 = { c3 68???????? 50 ff15???????? 85c0 751f 68???????? }
            // n = 7, score = 200
            //   c3                   | rol                 edx, 7
            //   68????????           |                     
            //   50                   | inc                 ecx
            //   ff15????????         |                     
            //   85c0                 | add                 edx, edx
            //   751f                 | and                 eax, edx
            //   68????????           |                     

        $sequence_13 = { 57 8b7d08 8d14dd00000000 8b0f c1e903 83e13f 894d0c }
            // n = 7, score = 200
            //   57                   | mov                 ecx, edx
            //   8b7d08               | not                 ecx
            //   8d14dd00000000       | add                 eax, dword ptr [edx + 0x10]
            //   8b0f                 | inc                 ecx
            //   c1e903               | lea                 edx, [eax + 0x4bdecfa9]
            //   83e13f               | inc                 ebp
            //   894d0c               | lea                 eax, [ecx - 0x944b4a0]

        $sequence_14 = { ffd6 ffb5e4feffff ffd6 57 85db 7439 81fb02010000 }
            // n = 7, score = 200
            //   ffd6                 | add                 edx, eax
            //   ffb5e4feffff         | add                 eax, dword ptr [edx + 0x10]
            //   ffd6                 | inc                 ecx
            //   57                   | lea                 edx, [eax + 0x4bdecfa9]
            //   85db                 | inc                 ebp
            //   7439                 | lea                 eax, [ecx - 0x944b4a0]
            //   81fb02010000         | add                 edx, eax

        $sequence_15 = { 50 e8???????? 6867010000 8d8529fcffff c68528fcffff00 6a00 50 }
            // n = 7, score = 200
            //   50                   | inc                 ecx
            //   e8????????           |                     
            //   6867010000           | add                 edx, edx
            //   8d8529fcffff         | and                 eax, edx
            //   c68528fcffff00       | mov                 ecx, edx
            //   6a00                 | add                 ecx, dword ptr [esi]
            //   50                   | add                 edx, ecx

    condition:
        7 of them and filesize < 445440
}