rule win_rawpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rawpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rawpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 59 85c0 757b 0fbe4604 50 e8???????? 59 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   757b                 | jne                 0x7d
            //   0fbe4604             | movsx               eax, byte ptr [esi + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { 8bf8 33c0 8a07 83f845 7c05 b845000000 83f83b }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   33c0                 | xor                 eax, eax
            //   8a07                 | mov                 al, byte ptr [edi]
            //   83f845               | cmp                 eax, 0x45
            //   7c05                 | jl                  7
            //   b845000000           | mov                 eax, 0x45
            //   83f83b               | cmp                 eax, 0x3b

        $sequence_2 = { 5d c3 55 8bec 83c4dc 33c0 33d2 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83c4dc               | add                 esp, -0x24
            //   33c0                 | xor                 eax, eax
            //   33d2                 | xor                 edx, edx

        $sequence_3 = { e8???????? 83c408 85c0 0f842e070000 8b4520 8d4df4 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f842e070000         | je                  0x734
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   50                   | push                eax

        $sequence_4 = { 8bc3 f7d8 83f803 750a bb08000000 e9???????? }
            // n = 6, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   f7d8                 | neg                 eax
            //   83f803               | cmp                 eax, 3
            //   750a                 | jne                 0xc
            //   bb08000000           | mov                 ebx, 8
            //   e9????????           |                     

        $sequence_5 = { 837df400 7507 8bf7 e9???????? 803f10 7526 }
            // n = 6, score = 100
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   7507                 | jne                 9
            //   8bf7                 | mov                 esi, edi
            //   e9????????           |                     
            //   803f10               | cmp                 byte ptr [edi], 0x10
            //   7526                 | jne                 0x28

        $sequence_6 = { c646ff10 c60601 46 8a45d0 8806 46 }
            // n = 6, score = 100
            //   c646ff10             | mov                 byte ptr [esi - 1], 0x10
            //   c60601               | mov                 byte ptr [esi], 1
            //   46                   | inc                 esi
            //   8a45d0               | mov                 al, byte ptr [ebp - 0x30]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi

        $sequence_7 = { 8a13 80c2d3 80ea02 720f 80c2fe 80ea02 7207 }
            // n = 7, score = 100
            //   8a13                 | mov                 dl, byte ptr [ebx]
            //   80c2d3               | add                 dl, 0xd3
            //   80ea02               | sub                 dl, 2
            //   720f                 | jb                  0x11
            //   80c2fe               | add                 dl, 0xfe
            //   80ea02               | sub                 dl, 2
            //   7207                 | jb                  9

        $sequence_8 = { 53 8b4510 83c6ff 50 57 52 e8???????? }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6ff               | add                 esi, -1
            //   50                   | push                eax
            //   57                   | push                edi
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_9 = { eb03 83c8ff 5f 5e 5b 59 5d }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   59                   | pop                 ecx
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 466944
}